/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import java.util.Objects;
import org.kohsuke.stapler.DataBoundConstructor;

public final class SpotConfiguration {
    public final boolean useBidPrice;
    public final String spotMaxBidPrice;
    public final boolean fallbackToOndemand;
    public final int spotBlockReservationDuration;

    @DataBoundConstructor
    public SpotConfiguration(boolean useBidPrice, String spotMaxBidPrice, boolean fallbackToOndemand, String spotBlockReservationDurationStr) {
        this.useBidPrice = useBidPrice;
        this.spotMaxBidPrice = spotMaxBidPrice;
        this.fallbackToOndemand = fallbackToOndemand;
        this.spotBlockReservationDuration = null == spotBlockReservationDurationStr || spotBlockReservationDurationStr.isEmpty() ? 0 : Integer.parseInt(spotBlockReservationDurationStr);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpotConfiguration config = (SpotConfiguration)obj;
        String normalizedBid = SpotConfiguration.normalizeBid(this.spotMaxBidPrice);
        String otherNormalizedBid = SpotConfiguration.normalizeBid(config.spotMaxBidPrice);
        boolean normalizedBidsAreEqual = normalizedBid == null ? otherNormalizedBid == null : normalizedBid.equals(otherNormalizedBid);
        boolean blockReservationIsEqual = true;
        if (this.spotBlockReservationDuration != config.spotBlockReservationDuration) {
            blockReservationIsEqual = false;
        }
        return this.useBidPrice == config.useBidPrice && this.fallbackToOndemand == config.fallbackToOndemand && normalizedBidsAreEqual && blockReservationIsEqual;
    }

    public int hashCode() {
        return Objects.hash(this.useBidPrice, this.spotMaxBidPrice, this.fallbackToOndemand);
    }

    public static String normalizeBid(String bid) {
        try {
            Float spotPrice = Float.valueOf(Float.parseFloat(bid));
            if ((double)spotPrice.floatValue() < 0.001) {
                return null;
            }
            return spotPrice.toString();
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

