/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.services.ec2.model.Instance;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Slave;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.InstanceState;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;

public class EC2Computer
extends SlaveComputer {
    private volatile Instance ec2InstanceDescription;

    public EC2Computer(EC2AbstractSlave slave) {
        super((Slave)slave);
    }

    public EC2AbstractSlave getNode() {
        return (EC2AbstractSlave)super.getNode();
    }

    @CheckForNull
    public String getInstanceId() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getInstanceId();
    }

    public String getEc2Type() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getEc2Type();
    }

    public String getSpotInstanceRequestId() {
        EC2AbstractSlave node = this.getNode();
        if (node instanceof EC2SpotSlave) {
            return ((EC2SpotSlave)node).getSpotInstanceRequestId();
        }
        return "";
    }

    public EC2Cloud getCloud() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getCloud();
    }

    public SlaveTemplate getSlaveTemplate() {
        EC2AbstractSlave node = this.getNode();
        if (node != null) {
            return node.getCloud().getTemplate(node.templateDescription);
        }
        return null;
    }

    public String getConsoleOutput() throws AmazonClientException {
        AmazonEC2 ec2 = this.getCloud().connect();
        GetConsoleOutputRequest request = new GetConsoleOutputRequest(this.getInstanceId());
        return ec2.getConsoleOutput(request).getOutput();
    }

    public Instance describeInstance() throws AmazonClientException, InterruptedException {
        if (this.ec2InstanceDescription == null) {
            this.ec2InstanceDescription = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        }
        return this.ec2InstanceDescription;
    }

    public Instance updateInstanceDescription() throws AmazonClientException, InterruptedException {
        this.ec2InstanceDescription = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        return this.ec2InstanceDescription;
    }

    public InstanceState getState() throws AmazonClientException, InterruptedException {
        this.ec2InstanceDescription = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        return InstanceState.find(this.ec2InstanceDescription.getState().getName());
    }

    public long getUptime() throws AmazonClientException, InterruptedException {
        return System.currentTimeMillis() - this.describeInstance().getLaunchTime().getTime();
    }

    public String getUptimeString() throws AmazonClientException, InterruptedException {
        return Util.getTimeSpanString((long)this.getUptime());
    }

    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        EC2AbstractSlave node = this.getNode();
        if (node != null) {
            node.terminate();
        }
        return new HttpRedirect("..");
    }

    @CheckForNull
    public String getRemoteAdmin() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getRemoteAdmin();
    }

    public int getSshPort() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? 22 : node.getSshPort();
    }

    public String getRootCommandPrefix() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? "" : node.getRootCommandPrefix();
    }

    public String getSlaveCommandPrefix() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? "" : node.getSlaveCommandPrefix();
    }

    public String getSlaveCommandSuffix() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? "" : node.getSlaveCommandSuffix();
    }

    public void onConnected() {
        EC2AbstractSlave node = this.getNode();
        if (node != null) {
            node.onConnected();
        }
    }
}

