/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension(ordinal=100.0)
public class NoDelayProvisionerStrategy
extends NodeProvisioner.Strategy {
    private static final Logger LOGGER = Logger.getLogger(NoDelayProvisionerStrategy.class.getName());

    public NodeProvisioner.StrategyDecision apply(NodeProvisioner.StrategyState strategyState) {
        Jenkins jenkinsInstance;
        Label label = strategyState.getLabel();
        LoadStatistics.LoadStatisticsSnapshot snapshot = strategyState.getSnapshot();
        int availableCapacity = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() + strategyState.getPlannedCapacitySnapshot() + strategyState.getAdditionalPlannedCapacity();
        int currentDemand = snapshot.getQueueLength();
        LOGGER.log(Level.FINE, "Available capacity={0}, currentDemand={1}", new Object[]{availableCapacity, currentDemand});
        if (availableCapacity < currentDemand && (jenkinsInstance = Jenkins.getInstance()) != null) {
            for (Cloud cloud : jenkinsInstance.clouds) {
                AmazonEC2Cloud ec2;
                if (!(cloud instanceof AmazonEC2Cloud) || !cloud.canProvision(label) || !(ec2 = (AmazonEC2Cloud)cloud).isNoDelayProvisioning()) continue;
                Collection plannedNodes = cloud.provision(label, currentDemand - availableCapacity);
                LOGGER.log(Level.FINE, "Planned {0} new nodes", plannedNodes.size());
                strategyState.recordPendingLaunches(plannedNodes);
                LOGGER.log(Level.FINE, "After provisioning, available capacity={0}, currentDemand={1}", new Object[]{availableCapacity += plannedNodes.size(), currentDemand});
                break;
            }
        }
        if (availableCapacity >= currentDemand) {
            LOGGER.log(Level.FINE, "Provisioning completed");
            return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
        }
        LOGGER.log(Level.FINE, "Provisioning not complete, consulting remaining strategies");
        return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
    }
}

