/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import hudson.init.InitMilestone;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.InstanceState;
import hudson.slaves.RetentionStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.math.NumberUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class EC2RetentionStrategy
extends RetentionStrategy<EC2Computer>
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(EC2RetentionStrategy.class.getName());
    public static final boolean DISABLED = Boolean.getBoolean(EC2RetentionStrategy.class.getName() + ".disabled");
    public final int idleTerminationMinutes;
    private transient ReentrantLock checkLock;
    private static final int STARTUP_TIME_DEFAULT_VALUE = 30;
    private static final int STARTUP_TIMEOUT = NumberUtils.toInt((String)System.getProperty(EC2RetentionStrategy.class.getCanonicalName() + ".startupTimeout", String.valueOf(30)), (int)30);

    @DataBoundConstructor
    public EC2RetentionStrategy(String idleTerminationMinutes) {
        this.readResolve();
        if (idleTerminationMinutes == null || idleTerminationMinutes.trim().isEmpty()) {
            this.idleTerminationMinutes = 0;
        } else {
            int value = 30;
            try {
                value = Integer.parseInt(idleTerminationMinutes);
            }
            catch (NumberFormatException nfe) {
                LOGGER.info("Malformed default idleTermination value: " + idleTerminationMinutes);
            }
            this.idleTerminationMinutes = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long check(EC2Computer c) {
        if (!this.checkLock.tryLock()) {
            return 1L;
        }
        try {
            long l = this.internalCheck(c);
            return l;
        }
        finally {
            this.checkLock.unlock();
        }
    }

    private long internalCheck(EC2Computer computer) {
        if (this.idleTerminationMinutes == 0 || computer.getNode() == null) {
            return 1L;
        }
        if (computer.isIdle() && !DISABLED) {
            InstanceState state;
            long uptime;
            try {
                uptime = computer.getUptime();
                state = computer.getState();
            }
            catch (AmazonClientException | InterruptedException e) {
                LOGGER.fine("Exception while checking host uptime for " + computer.getName() + ", will retry next check. Exception: " + e);
                return 1L;
            }
            if (computer.isOffline() && uptime < TimeUnit.MINUTES.toMillis(STARTUP_TIMEOUT)) {
                return 1L;
            }
            long idleMilliseconds = System.currentTimeMillis() - computer.getIdleStartMilliseconds();
            if (uptime < idleMilliseconds) {
                return 1L;
            }
            if (this.idleTerminationMinutes > 0) {
                if (!(idleMilliseconds <= TimeUnit.MINUTES.toMillis(this.idleTerminationMinutes) || InstanceState.STOPPED.equals((Object)state) && computer.getSlaveTemplate().stopOnTerminate)) {
                    LOGGER.info("Idle timeout of " + computer.getName() + " after " + TimeUnit.MILLISECONDS.toMinutes(idleMilliseconds) + " idle minutes, instance status" + state.toString());
                    computer.getNode().idleTimeout();
                }
            } else {
                int freeSecondsLeft = 3600 - (int)(TimeUnit.SECONDS.convert(uptime, TimeUnit.MILLISECONDS) % 3600L);
                if ((long)freeSecondsLeft <= TimeUnit.MINUTES.toSeconds(Math.abs(this.idleTerminationMinutes))) {
                    LOGGER.info("Idle timeout of " + computer.getName() + " after " + TimeUnit.MILLISECONDS.toMinutes(idleMilliseconds) + " idle minutes, with " + TimeUnit.SECONDS.toMinutes(freeSecondsLeft) + " minutes remaining in billing period");
                    computer.getNode().idleTimeout();
                }
            }
        }
        return 1L;
    }

    public void start(EC2Computer c) {
        if (Jenkins.getInstance().getInitLevel() != InitMilestone.COMPLETED) {
            InstanceState state = null;
            try {
                state = c.getState();
            }
            catch (AmazonClientException | InterruptedException | NullPointerException e) {
                LOGGER.log(Level.FINE, "Error getting EC2 instance state for " + c.getName(), e);
            }
            if (!InstanceState.PENDING.equals((Object)state) && !InstanceState.RUNNING.equals((Object)state)) {
                LOGGER.info("Ignoring start request for " + c.getName() + " during Jenkins startup due to EC2 instance state of " + (Object)((Object)state));
                return;
            }
        }
        LOGGER.info("Start requested for " + c.getName());
        c.connect(false);
    }

    protected Object readResolve() {
        this.checkLock = new ReentrantLock(false);
        return this;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        int maxTotalUses;
        EC2Computer computer = (EC2Computer)executor.getOwner();
        EC2AbstractSlave slaveNode = computer.getNode();
        if ((maxTotalUses = slaveNode.maxTotalUses--) <= -1) {
            LOGGER.fine("maxTotalUses set to unlimited (" + slaveNode.maxTotalUses + ") for agent " + slaveNode.instanceId);
            return;
        }
        if (maxTotalUses <= 1) {
            LOGGER.info("maxTotalUses drained - suspending agent " + slaveNode.instanceId);
            computer.setAcceptingTasks(false);
        } else {
            LOGGER.info("Agent " + slaveNode.instanceId + " has " + slaveNode.maxTotalUses + " builds left");
        }
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.postJobAction(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.postJobAction(executor);
    }

    private void postJobAction(Executor executor) {
        EC2Computer computer = (EC2Computer)executor.getOwner();
        EC2AbstractSlave slaveNode = computer.getNode();
        if (computer.countBusy() <= 1 && !computer.isAcceptingTasks()) {
            LOGGER.info("Agent " + slaveNode.instanceId + " is terminated due to maxTotalUses (" + slaveNode.maxTotalUses + ")");
            slaveNode.terminate();
        } else if (slaveNode.maxTotalUses == 1) {
            LOGGER.info("Agent " + slaveNode.instanceId + " is still in use by more than one (" + computer.countBusy() + ") executers.");
        }
    }

    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "EC2";
        }
    }
}

