/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.Region;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.Util;
import hudson.model.Failure;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.Cloud;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse;

public class AmazonEC2Cloud
extends EC2Cloud {
    private String region;
    public static final String CLOUD_ID_PREFIX = "ec2-";
    public static boolean testMode;
    private boolean noDelayProvisioning;

    @DataBoundConstructor
    public AmazonEC2Cloud(String cloudName, boolean useInstanceProfileForCredentials, String credentialsId, String region, String privateKey, String instanceCapStr, List<? extends SlaveTemplate> templates, String roleArn, String roleSessionName) {
        super(AmazonEC2Cloud.createCloudId(cloudName), useInstanceProfileForCredentials, credentialsId, privateKey, instanceCapStr, templates, roleArn, roleSessionName);
        this.region = region;
    }

    public String getCloudName() {
        return this.name.substring(CLOUD_ID_PREFIX.length());
    }

    public String getDisplayName() {
        return this.getCloudName();
    }

    private static String createCloudId(String cloudName) {
        return CLOUD_ID_PREFIX + cloudName.trim();
    }

    public String getRegion() {
        if (this.region == null) {
            this.region = "us-east-1";
        }
        if (this.region.indexOf(95) > 0) {
            return this.region.replace('_', '-').toLowerCase(Locale.ENGLISH);
        }
        return this.region;
    }

    public static URL getEc2EndpointUrl(String region) {
        try {
            return new URL("https://ec2." + region + "." + "amazonaws.com" + "/");
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    @Override
    public URL getEc2EndpointUrl() {
        return AmazonEC2Cloud.getEc2EndpointUrl(this.getRegion());
    }

    @Override
    public URL getS3EndpointUrl() {
        try {
            return new URL("https://" + this.getRegion() + ".s3.amazonaws.com/");
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public boolean isNoDelayProvisioning() {
        return this.noDelayProvisioning;
    }

    @DataBoundSetter
    public void setNoDelayProvisioning(boolean noDelayProvisioning) {
        this.noDelayProvisioning = noDelayProvisioning;
    }

    @Override
    protected AWSCredentialsProvider createCredentialsProvider() {
        return AmazonEC2Cloud.createCredentialsProvider(this.isUseInstanceProfileForCredentials(), this.getCredentialsId(), this.getRoleArn(), this.getRoleSessionName(), this.getRegion());
    }

    @Extension
    public static class DescriptorImpl
    extends EC2Cloud.DescriptorImpl {
        public String getDisplayName() {
            return "Amazon EC2";
        }

        public FormValidation doCheckCloudName(@QueryParameter String value) {
            try {
                Jenkins.checkGoodName((String)value);
            }
            catch (Failure e) {
                return FormValidation.error((String)e.getMessage());
            }
            String cloudId = AmazonEC2Cloud.createCloudId(value);
            int found = 0;
            for (Cloud c : Jenkins.getInstance().clouds) {
                if (!c.name.equals(cloudId)) continue;
                ++found;
            }
            if (found > 1) {
                return FormValidation.error((String)Messages.AmazonEC2Cloud_NonUniqName());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillRegionItems(@QueryParameter String altEC2Endpoint, @QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            if (testMode) {
                model.add("us-east-1");
                return model;
            }
            try {
                AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
                AmazonEC2 client = EC2Cloud.connect(credentialsProvider, this.determineEC2EndpointURL(altEC2Endpoint));
                DescribeRegionsResult regions = client.describeRegions();
                List regionList = regions.getRegions();
                for (Region r : regionList) {
                    String name = r.getRegionName();
                    model.add(name, name);
                }
            }
            catch (SdkClientException sdkClientException) {
                // empty catch block
            }
            return model;
        }

        @VisibleForTesting
        URL determineEC2EndpointURL(@Nullable String altEC2Endpoint) throws MalformedURLException {
            if (Util.fixEmpty((String)altEC2Endpoint) == null) {
                return new URL("http://ec2.amazonaws.com");
            }
            return new URL(altEC2Endpoint);
        }

        public FormValidation doTestConnection(@QueryParameter String region, @QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String privateKey, @QueryParameter String roleArn, @QueryParameter String roleSessionName) throws IOException, ServletException {
            if (Util.fixEmpty((String)region) == null) {
                region = "us-east-1";
            }
            return super.doTestConnection(AmazonEC2Cloud.getEc2EndpointUrl(region), useInstanceProfileForCredentials, credentialsId, privateKey, roleArn, roleSessionName, region);
        }

        public FormValidation doGenerateKey(StaplerResponse rsp, @QueryParameter String region, @QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String roleArn, @QueryParameter String roleSessionName) throws IOException, ServletException {
            return super.doGenerateKey(rsp, AmazonEC2Cloud.getEc2EndpointUrl(region), useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
        }
    }
}

