/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import hudson.plugins.ec2.win.winrm.NegotiateNTLMSchemaFactory;
import hudson.plugins.ec2.win.winrm.RuntimeIOException;
import hudson.plugins.ec2.win.winrm.WinRMConnectException;
import hudson.plugins.ec2.win.winrm.request.RequestFactory;
import hudson.plugins.ec2.win.winrm.soap.Namespaces;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class WinRMClient {
    private static final Logger log = Logger.getLogger(WinRMClient.class.getName());
    private static final String APPLICATION_SOAP_XML = "application/soap+xml";
    private final URL url;
    private final String username;
    private final String password;
    private String shellId;
    private String commandId;
    private int exitCode;
    private SimpleNamespaceContext namespaceContext;
    private final RequestFactory factory;
    private final ThreadLocal<BasicAuthCache> authCache = new ThreadLocal();
    private boolean useHTTPS;
    private Scheme httpsScheme;
    private BasicCredentialsProvider credsProvider;

    public WinRMClient(URL url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.factory = new RequestFactory(url);
        this.setupHTTPClient();
    }

    public void openShell() {
        log.log(Level.FINE, "opening winrm shell to: " + this.url);
        Document request = this.factory.newOpenShellRequest().build();
        this.shellId = WinRMClient.first(this.sendRequest(request), "//*[@Name='ShellId']");
        log.log(Level.FINER, "shellid: " + this.shellId);
    }

    public void executeCommand(String command) {
        log.log(Level.FINE, "winrm execute on " + this.shellId + " command: " + command);
        Document request = this.factory.newExecuteCommandRequest(this.shellId, command).build();
        this.commandId = WinRMClient.first(this.sendRequest(request), "//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":CommandId");
        log.log(Level.FINER, "winrm started execution on " + this.shellId + " commandId: " + this.commandId);
    }

    public void deleteShell() {
        if (this.shellId == null) {
            throw new IllegalStateException("no shell has been created");
        }
        log.log(Level.FINE, "closing winrm shell " + this.shellId);
        Document request = this.factory.newDeleteShellRequest(this.shellId).build();
        this.sendRequest(request);
    }

    public void signal() {
        if (this.commandId == null) {
            throw new IllegalStateException("no command is running");
        }
        log.log(Level.FINE, "signalling winrm shell " + this.shellId + " command: " + this.commandId);
        Document request = this.factory.newSignalRequest(this.shellId, this.commandId).build();
        this.sendRequest(request);
    }

    public void sendInput(byte[] input) {
        log.log(Level.FINE, "--> sending " + input.length);
        Document request = this.factory.newSendInputRequest(input, this.shellId, this.commandId).build();
        this.sendRequest(request);
    }

    public boolean slurpOutput(PipedOutputStream stdout, PipedOutputStream stderr) throws IOException {
        log.log(Level.FINE, "--> SlurpOutput");
        ImmutableMap streams = ImmutableMap.of((Object)"stdout", (Object)stdout, (Object)"stderr", (Object)stderr);
        Document request = this.factory.newGetOutputRequest(this.shellId, this.commandId).build();
        Document response = this.sendRequest(request);
        XPath xpath = DocumentHelper.createXPath((String)("//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":Stream"));
        this.namespaceContext = new SimpleNamespaceContext();
        this.namespaceContext.addNamespace(Namespaces.NS_WIN_SHELL.getPrefix(), Namespaces.NS_WIN_SHELL.getURI());
        xpath.setNamespaceContext((NamespaceContext)this.namespaceContext);
        Base64 base64 = new Base64();
        for (Element e : xpath.selectNodes((Object)response)) {
            PipedOutputStream stream = (PipedOutputStream)streams.get((Object)e.attribute("Name").getText().toLowerCase());
            byte[] decode = base64.decode(e.getText());
            log.log(Level.FINE, "piping " + decode.length + " bytes from " + e.attribute("Name").getText().toLowerCase());
            stream.write(decode);
        }
        XPath done = DocumentHelper.createXPath((String)"//*[@State='http://schemas.microsoft.com/wbem/wsman/1/windows/shell/CommandState/Done']");
        done.setNamespaceContext((NamespaceContext)this.namespaceContext);
        if (Iterables.isEmpty((Iterable)done.selectNodes((Object)response))) {
            log.log(Level.FINE, "keep going baby!");
            return true;
        }
        this.exitCode = Integer.parseInt(WinRMClient.first(response, "//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":ExitCode"));
        log.log(Level.FINE, "no more output - command is now done - exit code: " + this.exitCode);
        return false;
    }

    public int exitCode() {
        return this.exitCode;
    }

    private static String first(Document doc, String selector) {
        XPath xpath = DocumentHelper.createXPath((String)selector);
        try {
            return ((Element)Iterables.get((Iterable)xpath.selectNodes((Object)doc), (int)0)).getText();
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Malformed response for " + selector + " in " + doc.asXML());
        }
    }

    private void setupHTTPClient() {
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
    }

    private DefaultHttpClient buildHTTPClient() {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        if (!this.username.contains("\\") && !this.username.contains("/")) {
            httpclient.getAuthSchemes().register("Negotiate", (AuthSchemeFactory)new NegotiateNTLMSchemaFactory());
        }
        httpclient.setCredentialsProvider((CredentialsProvider)this.credsProvider);
        httpclient.getParams().setParameter("http.connection.timeout", (Object)5000);
        return httpclient;
    }

    private Document sendRequest(Document request) {
        return this.sendRequest(request, 0);
    }

    private Document sendRequest(Document request, int retry) {
        if (retry > 3) {
            throw new RuntimeException("Too many retry for request");
        }
        DefaultHttpClient httpclient = this.buildHTTPClient();
        BasicHttpContext context = new BasicHttpContext();
        if (this.authCache.get() == null) {
            this.authCache.set(new BasicAuthCache());
        }
        context.setAttribute("http.auth.auth-cache", (Object)this.authCache.get());
        if (this.useHTTPS) {
            httpclient.getConnectionManager().getSchemeRegistry().register(this.httpsScheme);
        }
        try {
            HttpPost post = new HttpPost(this.url.toURI());
            StringEntity entity = new StringEntity(request.asXML(), APPLICATION_SOAP_XML, "UTF-8");
            post.setEntity((HttpEntity)entity);
            log.log(Level.FINEST, "Request:\nPOST " + this.url + "\n" + request.asXML());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post, (HttpContext)context);
            HttpEntity responseEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (response.getStatusLine().getStatusCode() == 500 && responseEntity.getContentType() != null && entity.getContentType().getValue().startsWith(APPLICATION_SOAP_XML)) {
                    String respStr = EntityUtils.toString((HttpEntity)responseEntity);
                    if (respStr.contains("TimedOut")) {
                        return DocumentHelper.parseText((String)respStr);
                    }
                } else {
                    if (response.getStatusLine().getStatusCode() == 401) {
                        log.log(Level.WARNING, "winrm returned 401 - shouldn't happen though - retrying in 2 minutes");
                        try {
                            Thread.sleep(TimeUnit.MINUTES.toMillis(3L));
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        this.authCache.set(new BasicAuthCache());
                        log.log(Level.WARNING, "winrm returned 401 - retrying now");
                        return this.sendRequest(request, ++retry);
                    }
                    log.log(Level.WARNING, "winrm service " + this.shellId + " unexpected HTTP Response (" + response.getStatusLine().getReasonPhrase() + "): " + EntityUtils.toString((HttpEntity)response.getEntity()));
                    throw new RuntimeException("Unexpected HTTP response " + response.getStatusLine().getStatusCode() + " on " + this.url + ": " + response.getStatusLine().getReasonPhrase());
                }
            }
            if (responseEntity.getContentType() == null || !entity.getContentType().getValue().startsWith(APPLICATION_SOAP_XML)) {
                throw new RuntimeException("Unexepected WinRM content type: " + entity.getContentType());
            }
            Document responseDocument = DocumentHelper.parseText((String)EntityUtils.toString((HttpEntity)responseEntity));
            log.log(Level.FINEST, "Response:\n" + responseDocument.asXML());
            return responseDocument;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid WinRM URI " + this.url);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid WinRM body " + request.asXML());
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("HTTP Error " + e.getMessage(), e);
        }
        catch (HttpHostConnectException e) {
            log.log(Level.SEVERE, "Can't connect to host", e);
            throw new WinRMConnectException("Can't connect to host: " + e.getMessage(), e);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "I/O Exception in HTTP POST", e);
            throw new RuntimeIOException("I/O Exception " + e.getMessage(), e);
        }
        catch (ParseException e) {
            log.log(Level.SEVERE, "XML Parse exception in HTTP POST", e);
            throw new RuntimeException("Unparseable XML in winRM response " + e.getMessage(), e);
        }
        catch (DocumentException e) {
            log.log(Level.SEVERE, "XML Document exception in HTTP POST", e);
            throw new RuntimeException("Invalid XML document in winRM response " + e.getMessage(), e);
        }
    }

    public String getTimeout() {
        return this.factory.getTimeout();
    }

    public void setTimeout(String timeout) {
        this.factory.setTimeout(timeout);
    }

    public void setUseHTTPS(boolean useHTTPS) {
        this.useHTTPS = useHTTPS;
        if (useHTTPS) {
            try {
                SSLSocketFactory socketFactory = new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy(), (X509HostnameVerifier)new AllowAllHostnameVerifier());
                this.httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)socketFactory);
            }
            catch (KeyManagementException keyManagementException) {
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (KeyStoreException keyStoreException) {}
        } else {
            this.httpsScheme = null;
        }
    }
}

