/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.ec2.AMITypeData;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class UnixData
extends AMITypeData {
    private final String rootCommandPrefix;
    private final String slaveCommandPrefix;
    private final String sshPort;

    @DataBoundConstructor
    public UnixData(String rootCommandPrefix, String slaveCommandPrefix, String sshPort) {
        this.rootCommandPrefix = rootCommandPrefix;
        this.slaveCommandPrefix = slaveCommandPrefix;
        this.sshPort = sshPort;
    }

    @Override
    public boolean isWindows() {
        return false;
    }

    @Override
    public boolean isUnix() {
        return true;
    }

    public String getRootCommandPrefix() {
        return this.rootCommandPrefix;
    }

    public String getSlaveCommandPrefix() {
        return this.slaveCommandPrefix;
    }

    public String getSshPort() {
        return this.sshPort == null || this.sshPort.isEmpty() ? "22" : this.sshPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootCommandPrefix == null ? 0 : this.rootCommandPrefix.hashCode());
        result = 31 * result + (this.slaveCommandPrefix == null ? 0 : this.slaveCommandPrefix.hashCode());
        result = 31 * result + (this.sshPort == null ? 0 : this.sshPort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UnixData other = (UnixData)((Object)obj);
        if (StringUtils.isEmpty((String)this.rootCommandPrefix) ? !StringUtils.isEmpty((String)other.rootCommandPrefix) : !this.rootCommandPrefix.equals(other.rootCommandPrefix)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.slaveCommandPrefix) ? !StringUtils.isEmpty((String)other.slaveCommandPrefix) : !this.slaveCommandPrefix.equals(other.slaveCommandPrefix)) {
            return false;
        }
        return !(StringUtils.isEmpty((String)this.sshPort) ? !StringUtils.isEmpty((String)other.sshPort) : !this.sshPort.equals(other.sshPort));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AMITypeData> {
        public String getDisplayName() {
            return "unix";
        }
    }
}

