/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import org.kohsuke.stapler.DataBoundConstructor;

public final class SpotConfiguration {
    public final String spotMaxBidPrice;

    @DataBoundConstructor
    public SpotConfiguration(String spotMaxBidPrice) {
        this.spotMaxBidPrice = spotMaxBidPrice;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpotConfiguration config = (SpotConfiguration)obj;
        return SpotConfiguration.normalizeBid(this.spotMaxBidPrice).equals(SpotConfiguration.normalizeBid(config.spotMaxBidPrice));
    }

    public static String normalizeBid(String bid) {
        try {
            Float spotPrice = Float.valueOf(Float.parseFloat(bid));
            if ((double)spotPrice.floatValue() < 0.001) {
                return null;
            }
            return spotPrice.toString();
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

