/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import hudson.model.Descriptor;
import hudson.plugins.ec2.EC2Computer;
import hudson.slaves.RetentionStrategy;
import hudson.util.TimeUnit2;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.apache.commons.lang.math.NumberUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class EC2RetentionStrategy
extends RetentionStrategy<EC2Computer> {
    private static final Logger LOGGER = Logger.getLogger(EC2RetentionStrategy.class.getName());
    public static final boolean DISABLED = Boolean.getBoolean(EC2RetentionStrategy.class.getName() + ".disabled");
    public final int idleTerminationMinutes;
    private transient ReentrantLock checkLock;
    private static final int STARTUP_TIME_DEFAULT_VALUE = 30;
    private static final int STARTUP_TIMEOUT = NumberUtils.toInt((String)System.getProperty(EC2RetentionStrategy.class.getCanonicalName() + ".startupTimeout", String.valueOf(30)), (int)30);

    @DataBoundConstructor
    public EC2RetentionStrategy(String idleTerminationMinutes) {
        this.readResolve();
        if (idleTerminationMinutes == null || idleTerminationMinutes.trim().isEmpty()) {
            this.idleTerminationMinutes = 0;
        } else {
            int value = 30;
            try {
                value = Integer.parseInt(idleTerminationMinutes);
            }
            catch (NumberFormatException nfe) {
                LOGGER.info("Malformed default idleTermination value: " + idleTerminationMinutes);
            }
            this.idleTerminationMinutes = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long check(EC2Computer c) {
        if (!this.checkLock.tryLock()) {
            return 1L;
        }
        try {
            long l = this.internalCheck(c);
            return l;
        }
        finally {
            this.checkLock.unlock();
        }
    }

    private long internalCheck(EC2Computer computer) {
        if (this.idleTerminationMinutes == 0 || computer.getNode() == null) {
            return 1L;
        }
        if (computer.isIdle() && !DISABLED) {
            long uptime;
            try {
                uptime = computer.getUptime();
            }
            catch (AmazonClientException | InterruptedException e) {
                LOGGER.fine("Exception while checking host uptime for " + computer.getName() + ", will retry next check. Exception: " + e);
                return 1L;
            }
            if (computer.isOffline() && uptime < TimeUnit2.MINUTES.toMillis((long)STARTUP_TIMEOUT)) {
                return 1L;
            }
            long idleMilliseconds = System.currentTimeMillis() - computer.getIdleStartMilliseconds();
            if (this.idleTerminationMinutes > 0) {
                if (idleMilliseconds > TimeUnit2.MINUTES.toMillis((long)this.idleTerminationMinutes)) {
                    LOGGER.info("Idle timeout of " + computer.getName() + " after " + TimeUnit2.MILLISECONDS.toMinutes(idleMilliseconds) + " idle minutes");
                    computer.getNode().idleTimeout();
                }
            } else {
                int freeSecondsLeft = 3600 - (int)(TimeUnit2.SECONDS.convert(uptime, TimeUnit2.MILLISECONDS) % 3600L);
                if ((long)freeSecondsLeft <= TimeUnit.MINUTES.toSeconds(Math.abs(this.idleTerminationMinutes))) {
                    LOGGER.info("Idle timeout of " + computer.getName() + " after " + TimeUnit2.MILLISECONDS.toMinutes(idleMilliseconds) + " idle minutes, with " + TimeUnit2.SECONDS.toMinutes((long)freeSecondsLeft) + " minutes remaining in billing period");
                    computer.getNode().idleTimeout();
                }
            }
        }
        return 1L;
    }

    public void start(EC2Computer c) {
        LOGGER.info("Start requested for " + c.getName());
        c.connect(false);
    }

    protected Object readResolve() {
        this.checkLock = new ReentrantLock(false);
        return this;
    }

    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "EC2";
        }
    }
}

