/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Slave;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.InstanceState;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;

public class EC2Computer
extends SlaveComputer {
    private static final Logger LOGGER = Logger.getLogger(EC2Computer.class.getName());
    private volatile Instance ec2InstanceDescription;

    public EC2Computer(EC2AbstractSlave slave) {
        super((Slave)slave);
    }

    public EC2AbstractSlave getNode() {
        return (EC2AbstractSlave)super.getNode();
    }

    public String getInstanceId() {
        EC2AbstractSlave node = (EC2AbstractSlave)super.getNode();
        return node.getInstanceId();
    }

    public String getEc2Type() {
        return this.getNode().getEc2Type();
    }

    public String getSpotInstanceRequestId() {
        if (this.getNode() instanceof EC2SpotSlave) {
            return ((EC2SpotSlave)this.getNode()).getSpotInstanceRequestId();
        }
        return "";
    }

    public EC2Cloud getCloud() {
        EC2AbstractSlave node = this.getNode();
        if (node == null) {
            return null;
        }
        return node.getCloud();
    }

    public SlaveTemplate getSlaveTemplate() {
        return this.getCloud().getTemplate(this.getNode().templateDescription);
    }

    public String getConsoleOutput() throws AmazonClientException {
        AmazonEC2 ec2 = this.getCloud().connect();
        GetConsoleOutputRequest request = new GetConsoleOutputRequest(this.getInstanceId());
        return ec2.getConsoleOutput(request).getOutput();
    }

    public Instance describeInstance() throws AmazonClientException, InterruptedException {
        if (this.ec2InstanceDescription == null) {
            this.ec2InstanceDescription = this._describeInstance();
        }
        return this.ec2InstanceDescription;
    }

    public Instance updateInstanceDescription() throws AmazonClientException, InterruptedException {
        this.ec2InstanceDescription = this._describeInstance();
        return this.ec2InstanceDescription;
    }

    public InstanceState getState() throws AmazonClientException, InterruptedException {
        this.ec2InstanceDescription = this._describeInstance();
        return InstanceState.find(this.ec2InstanceDescription.getState().getName());
    }

    public long getUptime() throws AmazonClientException, InterruptedException {
        return System.currentTimeMillis() - this.describeInstance().getLaunchTime().getTime();
    }

    public String getUptimeString() throws AmazonClientException, InterruptedException {
        return Util.getTimeSpanString((long)this.getUptime());
    }

    private Instance _describeInstance() throws AmazonClientException, InterruptedException {
        for (int i = 0; i < 5; ++i) {
            try {
                return this._describeInstanceOnce();
            }
            catch (AmazonServiceException e) {
                if (!e.getErrorCode().equals("InvalidInstanceID.NotFound")) {
                    throw e;
                }
                Thread.sleep(5000L);
                continue;
            }
        }
        return this._describeInstanceOnce();
    }

    private Instance _describeInstanceOnce() throws AmazonClientException {
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        String instanceId = this.getNode().getInstanceId();
        request.setInstanceIds(Collections.singletonList(instanceId));
        List reservations = this.getCloud().connect().describeInstances(request).getReservations();
        if (reservations.size() != 1) {
            String message = "Unexpected number of reservations reported by EC2 for instance id '" + instanceId + "', expected 1 result, found " + reservations + ".";
            if (reservations.size() == 0) {
                message = message + " Instance seems to be dead.";
            }
            LOGGER.log(Level.INFO, message);
            throw new AmazonClientException(message);
        }
        Reservation reservation = (Reservation)reservations.get(0);
        List instances = reservation.getInstances();
        if (instances.size() != 1) {
            String message = "Unexpected number of instances reported by EC2 for instance id '" + instanceId + "', expected 1 result, found " + instances + ".";
            if (instances.size() == 0) {
                message = message + " Instance seems to be dead.";
            }
            LOGGER.log(Level.INFO, message);
            throw new AmazonClientException(message);
        }
        return (Instance)instances.get(0);
    }

    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        if (this.getNode() != null) {
            this.getNode().terminate();
        }
        return new HttpRedirect("..");
    }

    @CheckForNull
    public String getRemoteAdmin() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getRemoteAdmin();
    }

    public int getSshPort() {
        return this.getNode().getSshPort();
    }

    public String getRootCommandPrefix() {
        return this.getNode().getRootCommandPrefix();
    }

    public String getSlaveCommandPrefix() {
        return this.getNode().getSlaveCommandPrefix();
    }

    public void onConnected() {
        EC2AbstractSlave node = this.getNode();
        if (node != null) {
            node.onConnected();
        }
    }
}

