/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsImpl;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ProxyConfiguration;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class EC2Cloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(EC2Cloud.class.getName());
    public static final String DEFAULT_EC2_HOST = "us-east-1";
    public static final String AWS_URL_HOST = "amazonaws.com";
    public static final String EC2_SLAVE_TYPE_SPOT = "spot";
    public static final String EC2_SLAVE_TYPE_DEMAND = "demand";
    private static final SimpleFormatter sf = new SimpleFormatter();
    private final boolean useInstanceProfileForCredentials;
    @CheckForNull
    private String credentialsId;
    @Deprecated
    @CheckForNull
    private transient String accessId;
    @Deprecated
    @CheckForNull
    private transient Secret secretKey;
    protected final EC2PrivateKey privateKey;
    public final int instanceCap;
    private final List<? extends SlaveTemplate> templates;
    private transient KeyPair usableKeyPair;
    protected transient AmazonEC2 connection;
    private static AWSCredentialsProvider awsCredentialsProvider;

    protected EC2Cloud(String id, boolean useInstanceProfileForCredentials, String credentialsId, String privateKey, String instanceCapStr, List<? extends SlaveTemplate> templates) {
        super(id);
        this.useInstanceProfileForCredentials = useInstanceProfileForCredentials;
        this.credentialsId = credentialsId;
        this.privateKey = new EC2PrivateKey(privateKey);
        this.templates = templates == null ? Collections.emptyList() : templates;
        this.instanceCap = instanceCapStr.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.readResolve();
    }

    public abstract URL getEc2EndpointUrl() throws IOException;

    public abstract URL getS3EndpointUrl() throws IOException;

    protected Object readResolve() {
        for (SlaveTemplate slaveTemplate : this.templates) {
            slaveTemplate.parent = this;
        }
        if (this.accessId != null && this.credentialsId == null) {
            SystemCredentialsProvider systemCredentialsProvider = SystemCredentialsProvider.getInstance();
            for (Credentials credentials : systemCredentialsProvider.getCredentials()) {
                AmazonWebServicesCredentials awsCreds;
                AWSCredentials awsCredentials;
                if (!(credentials instanceof AmazonWebServicesCredentials) || !this.accessId.equals((awsCredentials = (awsCreds = (AmazonWebServicesCredentials)credentials).getCredentials()).getAWSAccessKeyId()) || !Secret.toString((Secret)this.secretKey).equals(awsCredentials.getAWSSecretKey())) continue;
                this.credentialsId = awsCreds.getId();
                this.accessId = null;
                this.secretKey = null;
                return this;
            }
            for (CredentialsStore credentialsStore : CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance())) {
                if (!(credentialsStore instanceof SystemCredentialsProvider.StoreImpl)) continue;
                try {
                    String credsId = UUID.randomUUID().toString();
                    credentialsStore.addCredentials(Domain.global(), (Credentials)new AWSCredentialsImpl(CredentialsScope.SYSTEM, credsId, this.accessId, this.secretKey.getEncryptedValue(), "EC2 Cloud - " + this.getDisplayName()));
                    this.credentialsId = credsId;
                    this.accessId = null;
                    this.secretKey = null;
                    return this;
                }
                catch (IOException e) {
                    this.credentialsId = null;
                    LOGGER.log(Level.WARNING, "Exception converting legacy configuration to the new credentials API", e);
                }
            }
            LOGGER.log(Level.WARNING, "EC2 Plugin could not migrate credentials to the Jenkins Global Credentials Store, EC2 Plugin for cloud {0} must be manually reconfigured", this.getDisplayName());
        }
        return this;
    }

    public boolean isUseInstanceProfileForCredentials() {
        return this.useInstanceProfileForCredentials;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public EC2PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public List<SlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public SlaveTemplate getTemplate(String template) {
        for (SlaveTemplate slaveTemplate : this.templates) {
            if (!slaveTemplate.description.equals(template)) continue;
            return slaveTemplate;
        }
        return null;
    }

    public SlaveTemplate getTemplate(Label label) {
        for (SlaveTemplate slaveTemplate : this.templates) {
            if (!(slaveTemplate.getMode() == Node.Mode.NORMAL ? label == null || label.matches(slaveTemplate.getLabelSet()) : slaveTemplate.getMode() == Node.Mode.EXCLUSIVE && label != null && label.matches(slaveTemplate.getLabelSet()))) continue;
            return slaveTemplate;
        }
        return null;
    }

    public synchronized KeyPair getKeyPair() throws AmazonClientException, IOException {
        if (this.usableKeyPair == null) {
            this.usableKeyPair = this.privateKey.find(this.connect());
        }
        return this.usableKeyPair;
    }

    public void doAttach(StaplerRequest req, StaplerResponse rsp, @QueryParameter String id) throws ServletException, IOException, AmazonClientException {
        this.checkPermission(PROVISION);
        SlaveTemplate t = this.getTemplates().get(0);
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        EC2AbstractSlave node = t.attach(id, (TaskListener)listener);
        Jenkins.getInstance().addNode((Node)node);
        rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
    }

    public HttpResponse doProvision(@QueryParameter String template) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        if (template == null) {
            throw HttpResponses.error((int)400, (String)"The 'template' query parameter is missing");
        }
        SlaveTemplate t = this.getTemplate(template);
        if (t == null) {
            throw HttpResponses.error((int)400, (String)("No such template: " + template));
        }
        try {
            EC2AbstractSlave node = this.getNewOrExistingAvailableSlave(t, null, true);
            if (node == null) {
                throw HttpResponses.error((int)400, (String)("Cloud or AMI instance cap would be exceeded for: " + template));
            }
            Jenkins.getInstance().addNode((Node)node);
            return HttpResponses.redirectViaContextPath((String)("/computer/" + node.getNodeName()));
        }
        catch (AmazonClientException e) {
            throw HttpResponses.error((int)500, (Throwable)e);
        }
    }

    private int countCurrentEC2Slaves(SlaveTemplate template) throws AmazonClientException {
        ArrayList<String> values;
        LOGGER.log(Level.FINE, "Counting current slaves: " + (template != null ? " AMI: " + template.getAmi() : " All AMIS"));
        int n = 0;
        HashSet<String> instanceIds = new HashSet<String>();
        String description = template != null ? template.description : null;
        for (Reservation r : this.connect().describeInstances().getReservations()) {
            for (Instance i : r.getInstances()) {
                InstanceStateName stateName;
                if (!this.isEc2ProvisionedAmiSlave(i.getTags(), description) || template != null && !template.getAmi().equals(i.getImageId()) || (stateName = InstanceStateName.fromValue((String)i.getState().getName())) == InstanceStateName.Terminated || stateName == InstanceStateName.ShuttingDown) continue;
                LOGGER.log(Level.FINE, "Existing instance found: " + i.getInstanceId() + " AMI: " + i.getImageId() + " Template: " + description);
                ++n;
                instanceIds.add(i.getInstanceId());
            }
        }
        List sirs = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (template != null) {
            values = new ArrayList<String>();
            values.add(template.getAmi());
            filters.add(new Filter("launch.image-id", values));
        }
        values = new ArrayList();
        values.add("jenkins_slave_type");
        filters.add(new Filter("tag-key", values));
        DescribeSpotInstanceRequestsRequest dsir = new DescribeSpotInstanceRequestsRequest().withFilters(filters);
        try {
            sirs = this.connect().describeSpotInstanceRequests(dsir).getSpotInstanceRequests();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Describe spot instance requests failed", ex);
        }
        HashSet<SpotInstanceRequest> sirSet = new HashSet<SpotInstanceRequest>();
        if (sirs != null) {
            block6: for (SpotInstanceRequest sir : sirs) {
                sirSet.add(sir);
                if (sir.getState().equals("open") || sir.getState().equals("active")) {
                    if (sir.getInstanceId() != null && instanceIds.contains(sir.getInstanceId())) continue;
                    LOGGER.log(Level.FINE, "Spot instance request found: " + sir.getSpotInstanceRequestId() + " AMI: " + sir.getInstanceId() + " state: " + sir.getState() + " status: " + sir.getStatus());
                    ++n;
                    if (sir.getInstanceId() == null) continue;
                    instanceIds.add(sir.getInstanceId());
                    continue;
                }
                for (Node node : Jenkins.getInstance().getNodes()) {
                    try {
                        EC2SpotSlave ec2Slave;
                        if (!(node instanceof EC2SpotSlave) || !(ec2Slave = (EC2SpotSlave)node).getSpotInstanceRequestId().equals(sir.getSpotInstanceRequestId())) continue;
                        LOGGER.log(Level.INFO, "Removing dead request: " + sir.getSpotInstanceRequestId() + " AMI: " + sir.getInstanceId() + " state: " + sir.getState() + " status: " + sir.getStatus());
                        Jenkins.getInstance().removeNode(node);
                        continue block6;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to remove node for dead request: " + sir.getSpotInstanceRequestId() + " AMI: " + sir.getInstanceId() + " state: " + sir.getState() + " status: " + sir.getStatus(), e);
                    }
                }
            }
        }
        for (Node node : Jenkins.getInstance().getNodes()) {
            if (!(node instanceof EC2SpotSlave)) continue;
            EC2SpotSlave ec2Slave = (EC2SpotSlave)node;
            SpotInstanceRequest sir = ec2Slave.getSpotRequest();
            if (sir == null) {
                LOGGER.log(Level.FINE, "Found spot node without request: " + ec2Slave.getSpotInstanceRequestId());
                ++n;
                continue;
            }
            if (sirSet.contains(sir)) continue;
            sirSet.add(sir);
            if (!sir.getState().equals("open") && !sir.getState().equals("active") || template == null) continue;
            List instanceTags = sir.getTags();
            for (Tag tag : instanceTags) {
                if (!StringUtils.equals((String)tag.getKey(), (String)"jenkins_slave_type") || !StringUtils.equals((String)tag.getValue(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_SPOT, template.description)) || !sir.getLaunchSpecification().getImageId().equals(template.getAmi()) || sir.getInstanceId() != null && instanceIds.contains(sir.getInstanceId())) continue;
                LOGGER.log(Level.FINE, "Spot instance request found (from node): " + sir.getSpotInstanceRequestId() + " AMI: " + sir.getInstanceId() + " state: " + sir.getState() + " status: " + sir.getStatus());
                ++n;
                if (sir.getInstanceId() == null) continue;
                instanceIds.add(sir.getInstanceId());
            }
        }
        return n;
    }

    private boolean isEc2ProvisionedAmiSlave(List<Tag> tags, String description) {
        for (Tag tag : tags) {
            if (!StringUtils.equals((String)tag.getKey(), (String)"jenkins_slave_type")) continue;
            if (description == null) {
                return true;
            }
            if (StringUtils.equals((String)tag.getValue(), (String)EC2_SLAVE_TYPE_DEMAND) || StringUtils.equals((String)tag.getValue(), (String)EC2_SLAVE_TYPE_SPOT)) {
                return true;
            }
            return StringUtils.equals((String)tag.getValue(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_DEMAND, description)) || StringUtils.equals((String)tag.getValue(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_SPOT, description));
        }
        return false;
    }

    private int getPossibleNewSlavesCount(SlaveTemplate template) throws AmazonClientException {
        int estimatedTotalSlaves = this.countCurrentEC2Slaves(null);
        int estimatedAmiSlaves = this.countCurrentEC2Slaves(template);
        int availableTotalSlaves = this.instanceCap - estimatedTotalSlaves;
        int availableAmiSlaves = template.getInstanceCap() - estimatedAmiSlaves;
        LOGGER.log(Level.FINE, "Available Total Slaves: " + availableTotalSlaves + " Available AMI slaves: " + availableAmiSlaves + " AMI: " + template.getAmi() + " TemplateDesc: " + template.description);
        return Math.min(availableAmiSlaves, availableTotalSlaves);
    }

    private synchronized EC2AbstractSlave getNewOrExistingAvailableSlave(SlaveTemplate template, Label requiredLabel, boolean forceCreateNew) {
        int possibleSlavesCount = this.getPossibleNewSlavesCount(template);
        if (possibleSlavesCount < 0) {
            LOGGER.log(Level.INFO, "Cannot provision - no capacity for instances: " + possibleSlavesCount);
            return null;
        }
        try {
            EnumSet<SlaveTemplate.ProvisionOptions> provisionOptions = EnumSet.noneOf(SlaveTemplate.ProvisionOptions.class);
            if (forceCreateNew) {
                provisionOptions = EnumSet.of(SlaveTemplate.ProvisionOptions.FORCE_CREATE);
            } else if (possibleSlavesCount > 0) {
                provisionOptions = EnumSet.of(SlaveTemplate.ProvisionOptions.ALLOW_CREATE);
            }
            return template.provision((TaskListener)StreamTaskListener.fromStdout(), requiredLabel, provisionOptions);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception during provisioning", e);
            return null;
        }
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            EC2AbstractSlave slave;
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            final SlaveTemplate t = this.getTemplate(label);
            LOGGER.log(Level.INFO, "Attempting to provision slave from template " + t + " needed by excess workload of " + excessWorkload + " units of label '" + label + "'");
            if (label == null) {
                LOGGER.log(Level.WARNING, String.format("Label is null - can't calculate how many executors slave will have. Using %s number of executors", t.getNumExecutors()));
            }
            while (excessWorkload > 0 && (slave = this.getNewOrExistingAvailableSlave(t, label, false)) != null) {
                LOGGER.log(Level.INFO, String.format("We have now %s computers", Jenkins.getInstance().getComputers().length));
                if (t.isNode().booleanValue()) {
                    Jenkins.getInstance().addNode((Node)slave);
                    LOGGER.log(Level.INFO, String.format("Added node named: %s, We have now %s computers", slave.getNodeName(), Jenkins.getInstance().getComputers().length));
                    r.add(new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                        @Override
                        public Node call() throws Exception {
                            long startTime = System.currentTimeMillis();
                            if (System.currentTimeMillis() - startTime < (long)(slave.launchTimeout * 1000)) {
                                return EC2Cloud.this.tryToCallSlave(slave, t);
                            }
                            LOGGER.log(Level.WARNING, "Expected - Instance - failed to connect within launch timeout");
                            return EC2Cloud.this.tryToCallSlave(slave, t);
                        }
                    }), t.getNumExecutors()));
                }
                excessWorkload -= t.getNumExecutors();
            }
            LOGGER.log(Level.INFO, "Attempting provision - finished, excess workload: " + excessWorkload);
            return r;
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Exception during provisioning", e);
            return Collections.emptyList();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception during provisioning", e);
            return Collections.emptyList();
        }
    }

    private EC2AbstractSlave tryToCallSlave(EC2AbstractSlave slave, SlaveTemplate template) {
        block2: {
            try {
                slave.toComputer().connect(false).get();
            }
            catch (Exception e) {
                if (template.spotConfig == null || !StringUtils.isNotEmpty((String)slave.getInstanceId()) || !slave.isConnected) break block2;
                LOGGER.log(Level.INFO, String.format("Instance id: %s for node: %s is connected now.", slave.getInstanceId(), slave.getNodeName()));
                return slave;
            }
        }
        return slave;
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    private AWSCredentialsProvider createCredentialsProvider() {
        return EC2Cloud.createCredentialsProvider(this.useInstanceProfileForCredentials, this.credentialsId);
    }

    public static String getSlaveTypeTagValue(String slaveType, String templateDescription) {
        return templateDescription != null ? slaveType + "_" + templateDescription : slaveType;
    }

    public static AWSCredentialsProvider createCredentialsProvider(boolean useInstanceProfileForCredentials, String credentialsId) {
        if (useInstanceProfileForCredentials) {
            return new InstanceProfileCredentialsProvider();
        }
        if (StringUtils.isBlank((String)credentialsId)) {
            return new DefaultAWSCredentialsProviderChain();
        }
        AmazonWebServicesCredentials credentials = EC2Cloud.getCredentials(credentialsId);
        return new StaticCredentialsProvider(credentials.getCredentials());
    }

    @CheckForNull
    private static AmazonWebServicesCredentials getCredentials(@Nullable String credentialsId) {
        if (StringUtils.isBlank((String)credentialsId)) {
            return null;
        }
        return (AmazonWebServicesCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public synchronized AmazonEC2 connect() throws AmazonClientException {
        try {
            if (this.connection == null) {
                this.connection = EC2Cloud.connect(this.createCredentialsProvider(), this.getEc2EndpointUrl());
            }
            return this.connection;
        }
        catch (IOException e) {
            throw new AmazonClientException("Failed to retrieve the endpoint", (Throwable)e);
        }
    }

    public static synchronized AmazonEC2 connect(AWSCredentialsProvider credentialsProvider, URL endpoint) {
        Proxy proxy;
        awsCredentialsProvider = credentialsProvider;
        ClientConfiguration config = new ClientConfiguration();
        config.setMaxErrorRetry(16);
        config.setSignerOverride("AWS4SignerType");
        ProxyConfiguration proxyConfig = Jenkins.getInstance().proxy;
        Proxy proxy2 = proxy = proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(endpoint.getHost());
        if (!proxy.equals(Proxy.NO_PROXY) && proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            config.setProxyHost(address.getHostName());
            config.setProxyPort(address.getPort());
            if (null != proxyConfig.getUserName()) {
                config.setProxyUsername(proxyConfig.getUserName());
                config.setProxyPassword(proxyConfig.getPassword());
            }
        }
        AmazonEC2Client client = new AmazonEC2Client(credentialsProvider, config);
        client.setEndpoint(endpoint.toString());
        return client;
    }

    public static String convertHostName(String ec2HostName) {
        if (ec2HostName == null || ec2HostName.length() == 0) {
            ec2HostName = DEFAULT_EC2_HOST;
        }
        if (!ec2HostName.contains(".")) {
            ec2HostName = "ec2." + ec2HostName + "." + AWS_URL_HOST;
        }
        return ec2HostName;
    }

    public static Integer convertPort(String ec2Port) {
        if (ec2Port == null || ec2Port.length() == 0) {
            return -1;
        }
        return Integer.parseInt(ec2Port);
    }

    public URL buildPresignedURL(String path) throws AmazonClientException {
        AWSCredentials credentials = awsCredentialsProvider.getCredentials();
        long expires = System.currentTimeMillis() + 3600000L;
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(path, credentials.getAWSSecretKey());
        request.setExpiration(new Date(expires));
        AmazonS3Client s3 = new AmazonS3Client(credentials);
        return s3.generatePresignedUrl(request);
    }

    public static URL checkEndPoint(String url) throws FormValidation {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw FormValidation.error((String)"Endpoint URL is not a valid URL");
        }
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message) {
        EC2Cloud.log(logger, level, listener, message, null);
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message, Throwable exception) {
        logger.log(level, message, exception);
        if (listener != null) {
            if (exception != null) {
                message = message + " Exception: " + exception;
            }
            LogRecord lr = new LogRecord(level, message);
            PrintStream printStream = listener.getLogger();
            printStream.print(sf.format(lr));
        }
    }

    public static abstract class DescriptorImpl
    extends Descriptor<Cloud> {
        public InstanceType[] getInstanceTypes() {
            return InstanceType.values();
        }

        public FormValidation doCheckUseInstanceProfileForCredentials(@QueryParameter boolean value) {
            if (value) {
                try {
                    new InstanceProfileCredentialsProvider().getCredentials();
                }
                catch (AmazonClientException e) {
                    return FormValidation.error((String)Messages.EC2Cloud_FailedToObtainCredentailsFromEC2(), (Object[])new Object[]{e.getMessage()});
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPrivateKey(@QueryParameter String value) throws IOException, ServletException {
            String line;
            boolean hasStart = false;
            boolean hasEnd = false;
            BufferedReader br = new BufferedReader(new StringReader(value));
            while ((line = br.readLine()) != null) {
                if (line.equals("-----BEGIN RSA PRIVATE KEY-----")) {
                    hasStart = true;
                }
                if (!line.equals("-----END RSA PRIVATE KEY-----")) continue;
                hasEnd = true;
            }
            if (!hasStart) {
                return FormValidation.error((String)"This doesn't look like a private key at all");
            }
            if (!hasEnd) {
                return FormValidation.error((String)"The private key is missing the trailing 'END RSA PRIVATE KEY' marker. Copy&paste error?");
            }
            return FormValidation.ok();
        }

        protected FormValidation doTestConnection(URL ec2endpoint, boolean useInstanceProfileForCredentials, String credentialsId, String privateKey) throws IOException, ServletException {
            try {
                EC2PrivateKey pk;
                AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
                AmazonEC2 ec2 = EC2Cloud.connect(credentialsProvider, ec2endpoint);
                ec2.describeInstances();
                if (privateKey == null) {
                    return FormValidation.error((String)"Private key is not specified. Click 'Generate Key' to generate one.");
                }
                if (privateKey.trim().length() > 0 && (pk = new EC2PrivateKey(privateKey)).find(ec2) == null) {
                    return FormValidation.error((String)("The EC2 key pair private key isn't registered to this EC2 region (fingerprint is " + pk.getFingerprint() + ")"));
                }
                return FormValidation.ok((String)Messages.EC2Cloud_Success());
            }
            catch (AmazonClientException e) {
                LOGGER.log(Level.WARNING, "Failed to check EC2 credential", e);
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doGenerateKey(StaplerResponse rsp, URL ec2EndpointUrl, boolean useInstanceProfileForCredentials, String credentialsId) throws IOException, ServletException {
            try {
                AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
                AmazonEC2 ec2 = EC2Cloud.connect(credentialsProvider, ec2EndpointUrl);
                List existingKeys = ec2.describeKeyPairs().getKeyPairs();
                int n = 0;
                while (true) {
                    boolean found = false;
                    for (KeyPairInfo k : existingKeys) {
                        if (!k.getKeyName().equals("hudson-" + n)) continue;
                        found = true;
                    }
                    if (!found) break;
                    ++n;
                }
                CreateKeyPairRequest request = new CreateKeyPairRequest("hudson-" + n);
                KeyPair key = ec2.createKeyPair(request).getKeyPair();
                rsp.addHeader("script", "findPreviousFormItem(button,'privateKey').value='" + key.getKeyMaterial().replace("\n", "\\n") + "'");
                return FormValidation.ok((String)Messages.EC2Cloud_Success());
            }
            catch (AmazonClientException e) {
                LOGGER.log(Level.WARNING, "Failed to check EC2 credential", e);
                return FormValidation.error((String)e.getMessage());
            }
        }

        public ListBoxModel doFillCredentialsIdItems() {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.always(), (Iterable)CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST));
        }
    }
}

