/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard.persistence.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTime;

public class DateTimeConverter
implements Converter {
    private static final Logger LOGGER = Logger.getLogger(DateTimeConverter.class.getName());

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mc) {
        DateTime dateTime = (DateTime)o;
        writer.setValue(dateTime.toString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext uc) {
        DateTime dateTime = DateTime.now();
        try {
            dateTime = DateTime.parse((String)reader.getValue());
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Could not parse DateTime value {0}. Returning DateTime.now().", reader.getValue());
        }
        return dateTime;
    }

    public boolean canConvert(Class clazz) {
        return DateTime.class.isAssignableFrom(clazz);
    }
}

