/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import de.codecentric.jenkins.dashboard.Messages;
import de.codecentric.jenkins.dashboard.api.environments.ServerEnvironment;
import de.codecentric.jenkins.dashboard.ec2.AwsKeyCredentials;
import de.codecentric.jenkins.dashboard.impl.environments.EnvironmentType;
import de.codecentric.jenkins.dashboard.impl.environments.ec2.AwsRegion;
import de.codecentric.jenkins.dashboard.impl.environments.ec2.EC2Connector;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ComboBoxModel;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Environment
extends AbstractDescribableImpl<Environment> {
    private static final Logger LOGGER = Logger.getLogger(Environment.class.getName());
    private String name;
    private String urlPrefix;
    private String urlPostfix;
    private EnvironmentType environmentType;
    private String awsInstance;
    private String region;
    private String credentials;
    private String buildJob;

    @DataBoundConstructor
    public Environment(@Nonnull String name, String urlPrefix, String urlPostfix, @Nonnull String credentials, @Nonnull String region, @Nonnull String environmentType, String awsInstance, String buildJob) {
        LOGGER.info("New environment created: " + credentials + ", " + region);
        this.setName(name);
        this.setCredentials(credentials);
        this.setRegion(region);
        this.setEnvironmentType(environmentType);
        this.setAwsInstance(awsInstance);
        this.setBuildJob(buildJob);
        this.setUrlPostfix(urlPostfix);
        this.setUrlPrefix(urlPrefix);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnvironmentType() {
        return this.environmentType.name();
    }

    public void setEnvironmentType(String environmentType) {
        this.environmentType = EnvironmentType.valueOf(environmentType);
    }

    public String getAwsInstance() {
        return this.awsInstance;
    }

    public void setAwsInstance(String awsInstance) {
        this.awsInstance = awsInstance;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getBuildJob() {
        return this.buildJob;
    }

    public void setBuildJob(String buildJob) {
        this.buildJob = buildJob;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public String getUrlPostfix() {
        return this.urlPostfix;
    }

    public void setUrlPostfix(String urlPostfix) {
        this.urlPostfix = urlPostfix;
    }

    @Extension
    public static class EnvironmentDescriptor
    extends Descriptor<Environment> {
        public String getDisplayName() {
            return Messages.Environment_DisplayName();
        }

        public ListBoxModel doFillEnvironmentTypeItems() {
            ListBoxModel model = new ListBoxModel();
            for (EnvironmentType value : EnvironmentType.values()) {
                model.add(value.getDescription(), value.name());
            }
            return model;
        }

        public ListBoxModel doFillCredentialsItems() {
            ListBoxModel model = new ListBoxModel();
            DomainRequirement domain = new DomainRequirement();
            for (AwsKeyCredentials credentials : CredentialsProvider.lookupCredentials(AwsKeyCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{domain})) {
                model.add(credentials.getId());
            }
            return model;
        }

        public ListBoxModel doFillAwsInstanceItems(@QueryParameter String region, @QueryParameter String credentials) {
            ListBoxModel model = new ListBoxModel();
            LOGGER.info("Looking for instances in " + region);
            if (StringUtils.isBlank((String)region)) {
                LOGGER.info("Region is empty");
                return model;
            }
            for (ServerEnvironment env : this.getEC2Instances(region, credentials)) {
                model.add(env.getEnvironmentTag());
            }
            return model;
        }

        private List<ServerEnvironment> getEC2Instances(String region, String credentialsId) {
            EC2Connector ec2 = EC2Connector.getEC2Connector(credentialsId);
            if (ec2 == null) {
                return Collections.emptyList();
            }
            return ec2.getEnvironments(Region.getRegion((Regions)Regions.fromName((String)region)));
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel model = new ListBoxModel();
            for (AwsRegion value : AwsRegion.values()) {
                model.add(value.getName(), value.getIdentifier());
            }
            return model;
        }

        public ComboBoxModel doFillBuildJobItems() {
            ComboBoxModel model = new ComboBoxModel();
            for (String jobName : Jenkins.getInstance().getJobNames()) {
                model.add((Object)jobName);
            }
            return model;
        }
    }
}

