/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.durabletask.Handler;

public abstract class Controller
implements Serializable {
    private static final long serialVersionUID = 1L;

    public void watch(@NonNull FilePath workspace, @NonNull Handler handler, @NonNull TaskListener listener) throws IOException, InterruptedException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Asynchronous mode is not implemented in " + this.getClass().getName());
    }

    public abstract boolean writeLog(FilePath var1, OutputStream var2) throws IOException, InterruptedException;

    @CheckForNull
    public Integer exitStatus(FilePath workspace, Launcher launcher, TaskListener logger) throws IOException, InterruptedException {
        if (Util.isOverridden(Controller.class, this.getClass(), (String)"exitStatus", (Class[])new Class[]{FilePath.class, Launcher.class})) {
            return this.exitStatus(workspace, launcher);
        }
        if (Util.isOverridden(Controller.class, this.getClass(), (String)"exitStatus", (Class[])new Class[]{FilePath.class})) {
            return this.exitStatus(workspace);
        }
        throw new AbstractMethodError("implement exitStatus(FilePath, Launcher, TaskListener)");
    }

    @Deprecated
    @CheckForNull
    public Integer exitStatus(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        return this.exitStatus(workspace, launcher, TaskListener.NULL);
    }

    @Deprecated
    @CheckForNull
    public Integer exitStatus(FilePath workspace) throws IOException, InterruptedException {
        return this.exitStatus(workspace, Controller.createLauncher(workspace));
    }

    @NonNull
    public byte[] getOutput(@NonNull FilePath workspace, @NonNull Launcher launcher) throws IOException, InterruptedException {
        throw new IOException("Did not implement getOutput in " + this.getClass().getName());
    }

    public void stop(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        if (!Util.isOverridden(Controller.class, this.getClass(), (String)"stop", (Class[])new Class[]{FilePath.class})) {
            throw new AbstractMethodError("implement stop(FilePath, Launcher)");
        }
        this.stop(workspace);
    }

    public void stop(FilePath workspace) throws IOException, InterruptedException {
        this.stop(workspace, Controller.createLauncher(workspace));
    }

    private static Launcher createLauncher(FilePath workspace) throws IOException, InterruptedException {
        return workspace.createLauncher((TaskListener)new LogTaskListener(Logger.getLogger(Controller.class.getName()), Level.FINE));
    }

    public abstract void cleanup(FilePath var1) throws IOException, InterruptedException;

    public String getDiagnostics(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        return this.toString();
    }
}

