/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import hudson.Platform;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import jenkins.MasterToSlaveFileCallable;

public final class AgentInfo
implements Serializable {
    private static final long serialVersionUID = 7599995179651071957L;
    private final OsType os;
    private final String binaryPath;
    private final String architecture;
    private boolean binaryCompatible;
    private boolean binaryCached;
    private boolean cachingAvailable;

    public AgentInfo(OsType os, String architecture, boolean binaryCompatible, String binaryPath, boolean cachingAvailable) {
        this.os = os;
        this.architecture = architecture;
        this.binaryPath = binaryPath;
        this.binaryCompatible = binaryCompatible;
        this.binaryCached = false;
        this.cachingAvailable = cachingAvailable;
    }

    public OsType getOs() {
        return this.os;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public void setBinaryAvailability(boolean isCached) {
        this.binaryCached = isCached;
    }

    public boolean isBinaryCompatible() {
        return this.binaryCompatible;
    }

    public boolean isBinaryCached() {
        return this.binaryCached;
    }

    public boolean isCachingAvailable() {
        return this.cachingAvailable;
    }

    public static final class GetAgentInfo
    extends MasterToSlaveFileCallable<AgentInfo> {
        private static final long serialVersionUID = 1L;
        private static final String BINARY_PREFIX = "durable_task_monitor_";
        private static final String CACHE_PATH = "caches/durable-task/";
        private static final String NOT_SUPPORTED = "NOTSUPPORTED";
        private String binaryVersion;

        GetAgentInfo(String pluginVersion) {
            this.binaryVersion = pluginVersion;
        }

        public AgentInfo invoke(File nodeRoot, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            boolean cachingAvailable;
            boolean isCached;
            String binaryPath;
            String osName;
            OsType os = Platform.isDarwin() ? OsType.DARWIN : (Platform.current() == Platform.WINDOWS ? OsType.WINDOWS : ((osName = System.getProperty("os.name")).equalsIgnoreCase("linux") ? OsType.LINUX : (osName.equalsIgnoreCase("z/OS") ? OsType.ZOS : (osName.equalsIgnoreCase("FreeBSD") ? OsType.FREEBSD : OsType.UNKNOWN))));
            String arch = System.getProperty("os.arch");
            String archType = "";
            if (os == OsType.DARWIN) {
                archType = arch.contains("aarch") || arch.contains("arm") ? "arm" : (arch.contains("amd") || arch.contains("x86") ? "amd" : NOT_SUPPORTED);
            }
            if (os == OsType.LINUX) {
                archType = arch;
                switch (arch) {
                    case "aarch64": 
                    case "ppc64le": {
                        archType = arch;
                        break;
                    }
                    case "amd64": {
                        archType = "64";
                        break;
                    }
                    case "x86": {
                        archType = "32";
                        break;
                    }
                    default: {
                        archType = NOT_SUPPORTED;
                        break;
                    }
                }
            } else {
                String bits = System.getProperty("sun.arch.data.model");
                archType = bits.equals("64") || bits.equals("32") ? archType + bits : archType + NOT_SUPPORTED;
            }
            boolean binaryCompatible = os == OsType.DARWIN || os == OsType.LINUX || os == OsType.WINDOWS && !archType.contains(NOT_SUPPORTED);
            String extension = "";
            if (os == OsType.WINDOWS) {
                extension = ".exe";
            }
            String binaryName = BINARY_PREFIX + this.binaryVersion + "_" + os.getNameForBinary() + "_" + archType + extension;
            try {
                Path cachePath = Paths.get(nodeRoot.toPath().toString(), CACHE_PATH);
                Files.createDirectories(cachePath, new FileAttribute[0]);
                File binaryFile = new File(cachePath.toFile(), binaryName);
                binaryPath = binaryFile.toPath().toString();
                isCached = binaryFile.exists();
                cachingAvailable = true;
            }
            catch (Exception e) {
                binaryPath = binaryName;
                isCached = false;
                cachingAvailable = false;
            }
            AgentInfo agentInfo = new AgentInfo(os, archType, binaryCompatible, binaryPath, cachingAvailable);
            agentInfo.setBinaryAvailability(isCached);
            return agentInfo;
        }
    }

    public static enum OsType {
        DARWIN("darwin"),
        LINUX("linux"),
        WINDOWS("win"),
        FREEBSD("freebsd"),
        ZOS("zos"),
        UNKNOWN("unknown");

        private final String binaryName;

        private OsType(String binaryName) {
            this.binaryName = binaryName;
        }

        public String getNameForBinary() {
            return this.binaryName;
        }
    }
}

