/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public final class WindowsBatchScript
extends FileMonitoringTask {
    private final String script;

    @DataBoundConstructor
    public WindowsBatchScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    protected FileMonitoringTask.FileMonitoringController doLaunch(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        if (launcher.isUnix()) {
            throw new IOException("Batch scripts can only be run on Windows nodes");
        }
        BatchController c = new BatchController(ws);
        c.getBatchFile1(ws).write(String.format("call \"%s\" > \"%s\" 2>&1\r\necho %%ERRORLEVEL%% > \"%s\"\r\n", c.getBatchFile2(ws), c.getLogFile(ws), c.getResultFile(ws)), "UTF-8");
        c.getBatchFile2(ws).write(this.script, "UTF-8");
        Launcher.ProcStarter ps = launcher.launch().cmds(new String[]{"cmd", "/c", c.getBatchFile1(ws).getRemote()}).envs((Map)envVars).pwd(ws);
        try {
            Launcher.ProcStarter.class.getMethod("quiet", Boolean.TYPE).invoke((Object)ps, true);
            listener.getLogger().println("[" + ws.getRemote().replaceFirst("^.+\\\\", "") + "] Running batch script");
        }
        catch (NoSuchMethodException x) {
        }
        catch (Exception x) {
            x.printStackTrace(listener.getLogger());
        }
        ps.start();
        return c;
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.WindowsBatchScript_windows_batch();
        }
    }

    private static final class BatchController
    extends FileMonitoringTask.FileMonitoringController {
        private static final long serialVersionUID = 1L;

        private BatchController(FilePath ws) throws IOException, InterruptedException {
            super(ws);
        }

        public FilePath getBatchFile1(FilePath ws) {
            return this.controlDir(ws).child("jenkins-wrap.bat");
        }

        public FilePath getBatchFile2(FilePath ws) {
            return this.controlDir(ws).child("jenkins-main.bat");
        }
    }
}

