/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import hudson.Launcher;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ProcessLiveness {
    public static boolean isAlive(VirtualChannel channel, int pid, Launcher launcher) throws IOException, InterruptedException {
        if (launcher instanceof Launcher.LocalLauncher || launcher instanceof Launcher.RemoteLauncher) {
            return (Boolean)channel.call((Callable)new Liveness(pid));
        }
        Launcher.ProcStarter ps = launcher.launch().cmds(new String[]{"ps", "-o", "pid=", Integer.toString(pid)});
        try {
            Launcher.ProcStarter.class.getMethod("quiet", Boolean.TYPE).invoke((Object)ps, true);
        }
        catch (NoSuchMethodException x) {
        }
        catch (Exception x) {
            Logger.getLogger(ProcessLiveness.class.getName()).log(Level.WARNING, null, x);
        }
        return ps.join() == 0;
    }

    private ProcessLiveness() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Liveness
    implements Callable<Boolean, RuntimeException> {
        private final int pid;

        Liveness(int pid) {
            this.pid = pid;
        }

        public Boolean call() throws RuntimeException {
            File proc = new File("/proc");
            if (!proc.isDirectory()) {
                return true;
            }
            return new File(proc, Integer.toString(this.pid)).isDirectory();
        }
    }
}

