/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Platform;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.jenkinsci.plugins.durabletask.ProcessLiveness;
import org.kohsuke.stapler.DataBoundConstructor;

public final class BourneShellScript
extends FileMonitoringTask {
    @Nonnull
    private final String script;

    @DataBoundConstructor
    public BourneShellScript(String script) {
        this.script = Util.fixNull((String)script);
    }

    public String getScript() {
        return this.script;
    }

    protected FileMonitoringTask.FileMonitoringController launchWithCookie(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        if (this.script.isEmpty()) {
            listener.getLogger().println("Warning: was asked to run an empty script");
        }
        ShellController c = new ShellController(ws);
        FilePath shf = c.getScriptFile(ws);
        String s = this.script;
        if (!s.startsWith("#!")) {
            String defaultShell = ((Shell.DescriptorImpl)Jenkins.getInstance().getInjector().getInstance(Shell.DescriptorImpl.class)).getShellOrDefault(ws.getChannel());
            s = "#!" + defaultShell + " -xe\n" + s;
        }
        shf.write(s, "UTF-8");
        shf.chmod(493);
        envVars.put(cookieVariable, "please-do-not-kill-me");
        String cmd = String.format("echo $$ > '%s'; jsc=%s; %s=$jsc '%s' > '%s' 2>&1; echo $? > '%s'", c.pidFile(ws), cookieValue, cookieVariable, shf, c.getLogFile(ws), c.getResultFile(ws)).replace("$", "$$");
        ArrayList<String> args = new ArrayList<String>();
        if (!((Boolean)ws.act((Callable)new DarwinCheck())).booleanValue()) {
            args.add("nohup");
        }
        args.addAll(Arrays.asList("sh", "-c", cmd));
        Launcher.ProcStarter ps = launcher.launch().cmds(args).envs((Map)envVars).pwd(ws);
        try {
            Launcher.ProcStarter.class.getMethod("quiet", Boolean.TYPE).invoke((Object)ps, true);
            listener.getLogger().println("[" + ws.getRemote().replaceFirst("^.+/", "") + "] Running shell script");
        }
        catch (NoSuchMethodException x) {
        }
        catch (Exception x) {
            x.printStackTrace(listener.getLogger());
        }
        ps.readStdout().readStderr();
        ps.start();
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DarwinCheck
    implements Callable<Boolean, RuntimeException> {
        private DarwinCheck() {
        }

        public Boolean call() throws RuntimeException {
            return Platform.isDarwin();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.BourneShellScript_bourne_shell();
        }
    }

    static final class ShellController
    extends FileMonitoringTask.FileMonitoringController {
        private int pid;
        private static final long serialVersionUID = 1L;

        private ShellController(FilePath ws) throws IOException, InterruptedException {
            super(ws);
        }

        public FilePath getScriptFile(FilePath ws) {
            return this.controlDir(ws).child("script.sh");
        }

        FilePath pidFile(FilePath ws) {
            return this.controlDir(ws).child("pid");
        }

        private synchronized int pid(FilePath ws) throws IOException, InterruptedException {
            FilePath pidFile;
            if (this.pid == 0 && (pidFile = this.pidFile(ws)).exists()) {
                try {
                    this.pid = Integer.parseInt(pidFile.readToString().trim());
                }
                catch (NumberFormatException x) {
                    throw new IOException("corrupted content in " + pidFile + ": " + x, x);
                }
            }
            return this.pid;
        }

        public Integer exitStatus(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            Integer status = super.exitStatus(workspace, launcher);
            if (status != null) {
                return status;
            }
            int _pid = this.pid(workspace);
            if (_pid > 0 && !ProcessLiveness.isAlive(workspace.getChannel(), _pid, launcher)) {
                status = super.exitStatus(workspace, launcher);
                if (status == null) {
                    status = -1;
                }
                return status;
            }
            return null;
        }
    }
}

