/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Platform;
import hudson.PluginWrapper;
import hudson.Proc;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Shell;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class BourneShellScript
extends FileMonitoringTask {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean FORCE_BINARY_WRAPPER = Boolean.getBoolean(BourneShellScript.class.getName() + ".FORCE_BINARY_WRAPPER");
    private static final Logger LOGGER = Logger.getLogger(BourneShellScript.class.getName());
    private static final String SYSTEM_DEFAULT_CHARSET = "SYSTEM_DEFAULT";
    private static final String LAUNCH_DIAGNOSTICS_PROP = BourneShellScript.class.getName() + ".LAUNCH_DIAGNOSTICS";
    private static boolean LAUNCH_DIAGNOSTICS = Boolean.getBoolean(LAUNCH_DIAGNOSTICS_PROP);
    static int HEARTBEAT_CHECK_INTERVAL = Integer.getInteger(BourneShellScript.class.getName() + ".HEARTBEAT_CHECK_INTERVAL", 300);
    private static int HEARTBEAT_MINIMUM_DELTA = Integer.getInteger(BourneShellScript.class.getName() + ".HEARTBEAT_MINIMUM_DELTA", 2);
    @Nonnull
    private final String script;
    private boolean capturingOutput;

    @DataBoundConstructor
    public BourneShellScript(String script) {
        this.script = Util.fixNull((String)script);
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    @Override
    protected FileMonitoringTask.FileMonitoringController launchWithCookie(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        Computer wsComputer;
        if (this.script.isEmpty()) {
            listener.getLogger().println("Warning: was asked to run an empty script");
        }
        if ((wsComputer = ws.toComputer()) == null) {
            throw new IOException("Unable to retrieve computer for workspace");
        }
        Node wsNode = wsComputer.getNode();
        if (wsNode == null) {
            throw new IOException("Unable to retrieve node for workspace");
        }
        FilePath nodeRoot = wsNode.getRootPath();
        if (nodeRoot == null) {
            throw new IOException("Unable to retrieve root path of node");
        }
        Jenkins jenkins = Jenkins.get();
        PluginWrapper durablePlugin = jenkins.getPluginManager().getPlugin("durable-task");
        if (durablePlugin == null) {
            throw new IOException("Unable to find durable task plugin");
        }
        String pluginVersion = StringUtils.substringBefore((String)durablePlugin.getVersion(), (String)"-");
        AgentInfo agentInfo = (AgentInfo)nodeRoot.act((FilePath.FileCallable)new GetAgentInfo(pluginVersion));
        OsType os = agentInfo.getOs();
        String scriptEncodingCharset = "UTF-8";
        if (os == OsType.ZOS) {
            Charset zOSSystemEncodingCharset = Charset.forName((String)ws.act((Callable)new getIBMzOsEncoding()));
            if (SYSTEM_DEFAULT_CHARSET.equals(this.getCharset())) {
                this.charset(zOSSystemEncodingCharset);
            }
            scriptEncodingCharset = zOSSystemEncodingCharset.name();
        }
        ShellController c = new ShellController(ws, os == OsType.ZOS);
        FilePath shf = c.getScriptFile(ws);
        shf.write(this.script, scriptEncodingCharset);
        String shell = null;
        if (!this.script.startsWith("#!")) {
            shell = ((Shell.DescriptorImpl)jenkins.getDescriptorByType(Shell.DescriptorImpl.class)).getShell();
            if (shell == null) {
                shell = "sh";
            }
        } else {
            shf.chmod(493);
        }
        String scriptPath = shf.getRemote();
        envVars.put(cookieVariable, "please-do-not-kill-me");
        List<String> launcherCmd = null;
        if (FORCE_BINARY_WRAPPER && agentInfo.isBinaryCompatible()) {
            FilePath controlDir = c.controlDir(ws);
            FilePath binary = agentInfo.isCachingAvailable() ? nodeRoot.child(agentInfo.getBinaryPath()) : controlDir.child(agentInfo.getBinaryPath());
            try (InputStream binaryStream = DurableTask.class.getResourceAsStream(binary.getName());){
                if (binaryStream != null) {
                    if (!agentInfo.isCachingAvailable() || !agentInfo.isBinaryCached()) {
                        binary.copyFrom(binaryStream);
                        binary.chmod(493);
                    }
                    launcherCmd = this.binaryLauncherCmd(c, ws, shell, controlDir.getRemote(), binary.getRemote(), scriptPath, cookieValue, cookieVariable);
                }
            }
        }
        if (launcherCmd == null) {
            launcherCmd = this.scriptLauncherCmd(c, ws, shell, os, scriptPath, cookieValue, cookieVariable);
        }
        LOGGER.log(Level.FINE, "launching {0}", launcherCmd);
        Launcher.ProcStarter ps = launcher.launch().cmds(launcherCmd).envs(BourneShellScript.escape(envVars)).pwd(ws).quiet(true);
        if (LAUNCH_DIAGNOSTICS) {
            ps.stdout(listener);
            ps.start();
        } else {
            ps.readStdout().readStderr();
            Proc p = ps.start();
            c.registerForCleanup(p.getStdout());
            c.registerForCleanup(p.getStderr());
        }
        return c;
    }

    @Nonnull
    private List<String> binaryLauncherCmd(ShellController c, FilePath ws, @Nullable String shell, String controlDirPath, String binaryPath, String scriptPath, String cookieValue, String cookieVariable) throws IOException, InterruptedException {
        String logFile = c.getLogFile(ws).getRemote();
        String resultFile = c.getResultFile(ws).getRemote();
        String outputFile = c.getOutputFile(ws).getRemote();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(binaryPath);
        cmd.add("-controldir=" + controlDirPath);
        cmd.add("-result=" + resultFile);
        cmd.add("-log=" + logFile);
        cmd.add("-cookiename=" + cookieVariable);
        cmd.add("-cookieval=" + cookieValue);
        cmd.add("-script=" + scriptPath);
        if (shell != null) {
            cmd.add("-shell=" + shell);
        }
        if (this.capturingOutput) {
            cmd.add("-output=" + outputFile);
        }
        if (!LAUNCH_DIAGNOSTICS) {
            cmd.add("-daemon");
        }
        return cmd;
    }

    @Nonnull
    private List<String> scriptLauncherCmd(ShellController c, FilePath ws, @CheckForNull String shell, OsType os, String scriptPath, String cookieValue, String cookieVariable) throws IOException, InterruptedException {
        FilePath logFile = c.getLogFile(ws);
        FilePath resultFile = c.getResultFile(ws);
        FilePath controlDir = c.controlDir(ws);
        String interpreter = "";
        if (shell != null && !this.script.startsWith("#!")) {
            interpreter = "'" + shell + "' -xe ";
        }
        if (os == OsType.WINDOWS) {
            scriptPath = scriptPath.replace("\\", "/");
        }
        String cmdString = this.capturingOutput ? String.format("{ while [ -d '%s' -a \\! -f '%s' ]; do touch '%s'; sleep 3; done } & jsc=%s; %s=$jsc %s '%s' > '%s' 2> '%s'; echo $? > '%s.tmp'; mv '%s.tmp' '%s'; wait", controlDir, resultFile, logFile, cookieValue, cookieVariable, interpreter, scriptPath, c.getOutputFile(ws), logFile, resultFile, resultFile, resultFile) : String.format("{ while [ -d '%s' -a \\! -f '%s' ]; do touch '%s'; sleep 3; done } & jsc=%s; %s=$jsc %s '%s' > '%s' 2>&1; echo $? > '%s.tmp'; mv '%s.tmp' '%s'; wait", controlDir, resultFile, logFile, cookieValue, cookieVariable, interpreter, scriptPath, logFile, resultFile, resultFile, resultFile);
        cmdString = cmdString.replace("$", "$$");
        ArrayList<String> cmd = new ArrayList<String>();
        if (os != OsType.DARWIN) {
            cmd.add("nohup");
        }
        if (LAUNCH_DIAGNOSTICS) {
            cmd.addAll(Arrays.asList("sh", "-c", cmdString));
        } else {
            cmd.addAll(Arrays.asList("sh", "-c", "(" + cmdString + ") >&- 2>&- &"));
        }
        return cmd;
    }

    static class StatusCheckWithEncoding
    extends MasterToSlaveFileCallable<Integer> {
        private final String charset;

        StatusCheckWithEncoding(String charset) {
            this.charset = charset;
        }

        @CheckForNull
        public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            if (f.exists() && f.length() > 0L) {
                try {
                    String fileString = com.google.common.io.Files.readFirstLine((File)f, (Charset)Charset.forName(this.charset));
                    if (fileString == null || fileString.isEmpty()) {
                        return null;
                    }
                    if ((fileString = fileString.trim()).isEmpty()) {
                        return null;
                    }
                    return Integer.parseInt(fileString);
                }
                catch (NumberFormatException x) {
                    throw new IOException("corrupted content in " + f + ": " + x, x);
                }
            }
            return null;
        }
    }

    private static final class getIBMzOsEncoding
    extends MasterToSlaveCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private getIBMzOsEncoding() {
        }

        public String call() throws RuntimeException {
            return System.getProperty("ibm.system.encoding");
        }
    }

    private static final class GetAgentInfo
    implements FilePath.FileCallable<AgentInfo> {
        private static final long serialVersionUID = 1L;
        private static final String BINARY_PREFIX = "durable_task_monitor_";
        private static final String CACHE_PATH = "caches/durable-task/";
        private String binaryVersion;

        GetAgentInfo(String pluginVersion) {
            this.binaryVersion = pluginVersion;
        }

        public AgentInfo invoke(File nodeRoot, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            boolean cachingAvailable;
            boolean isCached;
            String binaryPath;
            OsType os = Platform.isDarwin() ? OsType.DARWIN : (Platform.current() == Platform.WINDOWS ? OsType.WINDOWS : (Platform.current() == Platform.UNIX && System.getProperty("os.name").equals("z/OS") ? OsType.ZOS : (Platform.current() == Platform.UNIX && System.getProperty("os.name").equals("FreeBSD") ? OsType.FREEBSD : OsType.UNIX)));
            String arch = System.getProperty("os.arch");
            boolean binaryCompatible = os != OsType.FREEBSD && (arch.contains("86") || arch.contains("amd64"));
            String bits = System.getProperty("sun.arch.data.model");
            ArchBits archBits = bits.equals("64") ? ArchBits._64 : ArchBits._32;
            String binaryName = BINARY_PREFIX + this.binaryVersion + "_" + os.getNameForBinary() + (Object)((Object)archBits);
            try {
                Path cachePath = Paths.get(nodeRoot.toPath().toString(), CACHE_PATH);
                Files.createDirectories(cachePath, new FileAttribute[0]);
                File binaryFile = new File(cachePath.toFile(), binaryName);
                binaryPath = binaryFile.toPath().toString();
                isCached = binaryFile.exists();
                cachingAvailable = true;
            }
            catch (Exception e) {
                binaryPath = binaryName;
                isCached = false;
                cachingAvailable = false;
            }
            AgentInfo agentInfo = new AgentInfo(os, binaryCompatible, binaryPath, cachingAvailable);
            agentInfo.setBinaryAvailability(isCached);
            return agentInfo;
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }

        private static enum ArchBits {
            _32,
            _64;

        }
    }

    private static final class AgentInfo
    implements Serializable {
        private static final long serialVersionUID = 7599995179651071957L;
        private final OsType os;
        private final String binaryPath;
        private boolean binaryCompatible;
        private boolean binaryCached;
        private boolean cachingAvailable;

        public AgentInfo(OsType os, boolean binaryCompatible, String binaryPath, boolean cachingAvailable) {
            this.os = os;
            this.binaryPath = binaryPath;
            this.binaryCompatible = binaryCompatible;
            this.binaryCached = false;
            this.cachingAvailable = cachingAvailable;
        }

        public OsType getOs() {
            return this.os;
        }

        public String getBinaryPath() {
            return this.binaryPath;
        }

        public void setBinaryAvailability(boolean isCached) {
            this.binaryCached = isCached;
        }

        public boolean isBinaryCompatible() {
            return this.binaryCompatible;
        }

        public boolean isBinaryCached() {
            return this.binaryCached;
        }

        public boolean isCachingAvailable() {
            return this.cachingAvailable;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.BourneShellScript_bourne_shell();
        }
    }

    static final class ShellController
    extends FileMonitoringTask.FileMonitoringController {
        private transient long lastCheck;
        private transient long checkedTimestamp;
        private final boolean isZos;
        private static final long serialVersionUID = 1L;

        private ShellController(FilePath ws, boolean zOsFlag) throws IOException, InterruptedException {
            super(ws);
            this.isZos = zOsFlag;
        }

        public FilePath getScriptFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("script.sh");
        }

        private FilePath pidFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("pid");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected Integer exitStatus(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
            long currentTimestamp;
            block10: {
                block9: {
                    Integer status;
                    if (this.isZos) {
                        FilePath statusFile = this.getResultFile(workspace);
                        status = (Integer)statusFile.act((FilePath.FileCallable)new StatusCheckWithEncoding(this.getCharset()));
                    } else {
                        status = super.exitStatus(workspace, listener);
                    }
                    if (status != null) {
                        LOGGER.log(Level.FINE, "found exit code {0} in {1}", new Object[]{status, this.controlDir});
                        return status;
                    }
                    long now = System.nanoTime();
                    if (this.lastCheck == 0L) {
                        LOGGER.log(Level.FINE, "starting check in {0}", this.controlDir);
                        this.lastCheck = now;
                        return null;
                    }
                    if (now <= this.lastCheck + TimeUnit.SECONDS.toNanos(HEARTBEAT_CHECK_INTERVAL)) return null;
                    this.lastCheck = now;
                    currentTimestamp = this.getLogFile(workspace).lastModified();
                    if (currentTimestamp == 0L) {
                        listener.getLogger().println("process apparently never started in " + this.controlDir);
                        if (LAUNCH_DIAGNOSTICS) return this.recordExitStatus(workspace, -2);
                        listener.getLogger().println("(running Jenkins temporarily with -D" + LAUNCH_DIAGNOSTICS_PROP + "=true might make the problem clearer)");
                        return this.recordExitStatus(workspace, -2);
                    }
                    if (this.checkedTimestamp <= 0L) break block9;
                    if (currentTimestamp < this.checkedTimestamp) {
                        listener.getLogger().println("apparent clock skew in " + this.controlDir);
                        break block10;
                    } else if (currentTimestamp < this.checkedTimestamp + TimeUnit.SECONDS.toMillis(HEARTBEAT_MINIMUM_DELTA)) {
                        FilePath pidFile = this.pidFile(workspace);
                        if (!pidFile.exists()) {
                            listener.getLogger().println("wrapper script does not seem to be touching the log file in " + this.controlDir);
                            listener.getLogger().println("(JENKINS-48300: if on an extremely laggy filesystem, consider -Dorg.jenkinsci.plugins.durabletask.BourneShellScript.HEARTBEAT_CHECK_INTERVAL=86400)");
                            return this.recordExitStatus(workspace, -1);
                        }
                        listener.getLogger().println("still have " + pidFile + " so heartbeat checks unreliable; process may or may not be alive");
                    }
                    break block10;
                }
                LOGGER.log(Level.FINE, "seeing recent log file modifications in {0}", this.controlDir);
            }
            this.checkedTimestamp = currentTimestamp;
            return null;
        }

        private int recordExitStatus(FilePath workspace, int code) throws IOException, InterruptedException {
            this.getResultFile(workspace).write(Integer.toString(code), null);
            return code;
        }
    }

    private static enum OsType {
        DARWIN("darwin"),
        UNIX("unix"),
        WINDOWS("windows"),
        FREEBSD("freebsd"),
        ZOS("zos");

        private final String binaryName;

        private OsType(String binaryName) {
            this.binaryName = binaryName;
        }

        public String getNameForBinary() {
            return this.binaryName;
        }
    }
}

