/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class PowershellScript
extends FileMonitoringTask {
    private final String script;
    private String powershellBinary = "powershell";
    private boolean capturingOutput;

    @DataBoundConstructor
    public PowershellScript(String script) {
        this.script = script;
    }

    public String getPowershellBinary() {
        return this.powershellBinary;
    }

    @DataBoundSetter
    public void setPowershellBinary(String powershellBinary) {
        this.powershellBinary = powershellBinary;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    @Override
    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="%n from master might be \\n")
    protected FileMonitoringTask.FileMonitoringController doLaunch(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        PowershellController c = new PowershellController(ws);
        String cmd = this.capturingOutput ? String.format(". '%s'; Execute-AndWriteOutput -MainScript '%s' -OutputFile '%s' -LogFile '%s' -ResultFile '%s' -CaptureOutput;", PowershellScript.quote(c.getPowerShellHelperFile(ws)), PowershellScript.quote(c.getPowerShellScriptFile(ws)), PowershellScript.quote(c.getOutputFile(ws)), PowershellScript.quote(c.getLogFile(ws)), PowershellScript.quote(c.getResultFile(ws))) : String.format(". '%s'; Execute-AndWriteOutput -MainScript '%s' -LogFile '%s' -ResultFile '%s';", PowershellScript.quote(c.getPowerShellHelperFile(ws)), PowershellScript.quote(c.getPowerShellWrapperFile(ws)), PowershellScript.quote(c.getLogFile(ws)), PowershellScript.quote(c.getResultFile(ws)));
        String powershellArgs = launcher.isUnix() ? "-NoProfile -NonInteractive" : "-NoProfile -NonInteractive -ExecutionPolicy Bypass";
        args.add(this.powershellBinary);
        args.addAll(Arrays.asList(powershellArgs.split(" ")));
        args.addAll(Arrays.asList("-Command", cmd));
        String scriptWrapper = String.format("[CmdletBinding()]\r\nparam()\r\n& %s %s -Command '& ''%s''; exit $LASTEXITCODE;';\r\nexit $LASTEXITCODE;", this.powershellBinary, powershellArgs, PowershellScript.quote(PowershellScript.quote(c.getPowerShellScriptFile(ws))));
        String scriptWithExit = this.script + "\r\nexit $LASTEXITCODE;";
        c.getPowerShellHelperFile(ws).copyFrom(((Object)((Object)this)).getClass().getResource("powershellHelper.ps1"));
        if (launcher.isUnix() || "pwsh".equals(this.powershellBinary)) {
            c.getPowerShellScriptFile(ws).write(scriptWithExit, "UTF-8");
            if (!this.capturingOutput) {
                c.getPowerShellWrapperFile(ws).write(scriptWrapper, "UTF-8");
            }
        } else {
            PowershellScript.writeWithBom(c.getPowerShellScriptFile(ws), scriptWithExit);
            if (!this.capturingOutput) {
                PowershellScript.writeWithBom(c.getPowerShellWrapperFile(ws), scriptWrapper);
            }
        }
        Launcher.ProcStarter ps = launcher.launch().cmds(args).envs(PowershellScript.escape(envVars)).pwd(ws).quiet(true);
        ps.readStdout().readStderr();
        ps.start();
        return c;
    }

    private static String quote(FilePath f) {
        return PowershellScript.quote(f.getRemote());
    }

    private static String quote(String f) {
        return f.replace("'", "''");
    }

    private static void writeWithBom(FilePath f, String contents) throws IOException, InterruptedException {
        OutputStream out = f.write();
        out.write(new byte[]{-17, -69, -65});
        out.write(contents.getBytes(Charset.forName("UTF-8")));
        out.flush();
        out.close();
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.PowershellScript_powershell();
        }

        public ListBoxModel doFillPowershellBinary() {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("powershell"), new ListBoxModel.Option("pwsh")});
        }
    }

    private static final class PowershellController
    extends FileMonitoringTask.FileMonitoringController {
        private static final long serialVersionUID = 1L;

        private PowershellController(FilePath ws) throws IOException, InterruptedException {
            super(ws);
        }

        public FilePath getPowerShellScriptFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellScript.ps1");
        }

        public FilePath getPowerShellHelperFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellHelper.ps1");
        }

        public FilePath getPowerShellWrapperFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellWrapper.ps1");
        }
    }
}

