/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import com.google.common.io.Files;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.Terminator;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.DaemonThreadFactory;
import hudson.remoting.NamingThreadFactory;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.slaves.WorkspaceList;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.durabletask.Handler;

public abstract class FileMonitoringTask
extends DurableTask {
    private static final Logger LOGGER = Logger.getLogger(FileMonitoringTask.class.getName());
    private static final String COOKIE = "JENKINS_SERVER_COOKIE";
    private static final String SYSTEM_DEFAULT_CHARSET = "SYSTEM_DEFAULT";
    @CheckForNull
    private String charset;
    private static ScheduledExecutorService watchService;

    private static String cookieFor(FilePath workspace) {
        return "durable-" + Util.getDigestOf((String)workspace.getRemote());
    }

    @Override
    public final Controller launch(EnvVars env, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        FileMonitoringController controller = this.launchWithCookie(workspace, launcher, listener, env, COOKIE, FileMonitoringTask.cookieFor(workspace));
        controller.charset = this.charset;
        return controller;
    }

    protected FileMonitoringController launchWithCookie(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        envVars.put(cookieVariable, cookieValue);
        return this.doLaunch(workspace, launcher, listener, envVars);
    }

    @Override
    public final void charset(Charset cs) {
        this.charset = cs.name();
    }

    @Override
    public final void defaultCharset() {
        this.charset = SYSTEM_DEFAULT_CHARSET;
    }

    @CheckForNull
    final String getCharset() {
        return this.charset;
    }

    protected FileMonitoringController doLaunch(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        throw new AbstractMethodError("override either doLaunch or launchWithCookie");
    }

    protected static Map<String, String> escape(EnvVars envVars) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        for (Map.Entry entry : envVars.entrySet()) {
            m.put((String)entry.getKey(), ((String)entry.getValue()).replace("$", "$$"));
        }
        return m;
    }

    private static synchronized ScheduledExecutorService watchService() {
        if (watchService == null) {
            watchService = new ScheduledThreadPoolExecutor(5, (ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "FileMonitoringTask watcher"));
        }
        return watchService;
    }

    @Terminator
    public static synchronized void shutDownWatchService() {
        if (watchService != null) {
            watchService.shutdownNow();
            watchService = null;
        }
    }

    private static class Watcher
    implements Runnable {
        private final FileMonitoringController controller;
        private final FilePath workspace;
        private final Handler handler;
        private final TaskListener listener;
        @CheckForNull
        private final Charset cs;

        Watcher(FileMonitoringController controller, FilePath workspace, Handler handler, TaskListener listener) {
            this.controller = controller;
            this.workspace = workspace;
            this.handler = handler;
            this.listener = listener;
            this.cs = FileMonitoringController.transcodingCharset(controller.charset);
        }

        @Override
        public void run() {
            try {
                FilePath logFile;
                long len;
                Integer exitStatus = this.controller.exitStatus(this.workspace, this.listener);
                long lastLocation = 0L;
                FilePath lastLocationFile = this.controller.getLastLocationFile(this.workspace);
                if (lastLocationFile.exists()) {
                    lastLocation = Long.parseLong(lastLocationFile.readToString());
                }
                if ((len = (logFile = this.controller.getLogFile(this.workspace)).length()) > lastLocation) {
                    assert (!logFile.isRemote());
                    try (FileChannel ch = FileChannel.open(Paths.get(logFile.getRemote(), new String[0]), StandardOpenOption.READ);){
                        InputStream locallyEncodedStream = Channels.newInputStream(ch.position(lastLocation));
                        InputStream utf8EncodedStream = this.cs == null ? locallyEncodedStream : new ReaderInputStream((Reader)new InputStreamReader(locallyEncodedStream, this.cs), StandardCharsets.UTF_8);
                        this.handler.output(utf8EncodedStream);
                        lastLocationFile.write(Long.toString(ch.position()), null);
                    }
                }
                if (exitStatus != null) {
                    byte[] output = this.controller.getOutputFile(this.workspace).exists() ? this.controller.getOutput(this.workspace) : null;
                    this.handler.exited(exitStatus, output);
                    this.controller.cleanup(this.workspace);
                } else {
                    if (!this.controller.controlDir(this.workspace).isDirectory()) {
                        LOGGER.log(Level.WARNING, "giving up on watching nonexistent {0}", this.controller.controlDir);
                        return;
                    }
                    FileMonitoringTask.watchService().schedule(this, 100L, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "giving up on watching " + this.controller.controlDir, x);
            }
        }
    }

    private static class StartWatching
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final FileMonitoringController controller;
        private final Handler handler;
        private final TaskListener listener;

        StartWatching(FileMonitoringController controller, Handler handler, TaskListener listener) {
            this.controller = controller;
            this.handler = handler;
            this.listener = listener;
        }

        public Void invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
            FileMonitoringTask.watchService().submit(new Watcher(this.controller, new FilePath(workspace), this.handler, this.listener));
            return null;
        }
    }

    protected static class FileMonitoringController
    extends Controller {
        String controlDir;
        private String id;
        private long lastLocation;
        @CheckForNull
        private String charset;
        private volatile transient AtomicReference<Charset> writeLogCs;
        static final StatusCheck STATUS_CHECK_INSTANCE = new StatusCheck();
        private static final long serialVersionUID = 1L;

        String getCharset() {
            return this.charset;
        }

        protected FileMonitoringController(FilePath ws) throws IOException, InterruptedException {
            ws.mkdirs();
            FilePath cd = FileMonitoringController.tempDir(ws).child("durable-" + Util.getDigestOf((String)UUID.randomUUID().toString()).substring(0, 8));
            cd.mkdirs();
            this.controlDir = cd.getRemote();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean writeLog(FilePath workspace, OutputStream sink) throws IOException, InterruptedException {
            boolean bl;
            OutputStream transcodedSink;
            if (this.writeLogCs == null) {
                String cs;
                this.writeLogCs = FileMonitoringTask.SYSTEM_DEFAULT_CHARSET.equals(this.charset) ? new AtomicReference<Charset>((cs = (String)workspace.act((Callable)new TranscodingCharsetForSystemDefault())) == null ? null : Charset.forName(cs)) : new AtomicReference<Charset>(FileMonitoringController.transcodingCharset(this.charset));
                LOGGER.log(Level.FINE, "remote transcoding charset: {0}", this.writeLogCs);
            }
            FilePath log = this.getLogFile(workspace);
            if (this.writeLogCs.get() == null) {
                transcodedSink = sink;
            } else {
                CharsetDecoder decoder = this.writeLogCs.get().newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                transcodedSink = new WriterOutputStream((Writer)new OutputStreamWriter(sink, StandardCharsets.UTF_8), decoder, 1024, true);
            }
            CountingOutputStream cos = new CountingOutputStream(transcodedSink);
            try {
                log.act((FilePath.FileCallable)new WriteLog(this.lastLocation, (OutputStream)new RemoteOutputStream((OutputStream)cos)));
                bl = cos.getByteCount() > 0L;
            }
            catch (Throwable throwable) {
                transcodedSink.flush();
                long written = cos.getByteCount();
                if (written > 0L) {
                    LOGGER.log(Level.FINE, "copied {0} bytes from {1}", new Object[]{written, log});
                    this.lastLocation += written;
                }
                throw throwable;
            }
            transcodedSink.flush();
            long written = cos.getByteCount();
            if (written > 0L) {
                LOGGER.log(Level.FINE, "copied {0} bytes from {1}", new Object[]{written, log});
                this.lastLocation += written;
            }
            return bl;
        }

        @Override
        public Integer exitStatus(FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            return this.exitStatus(workspace, listener);
        }

        @CheckForNull
        protected Integer exitStatus(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
            FilePath status = this.getResultFile(workspace);
            return (Integer)status.act((FilePath.FileCallable)STATUS_CHECK_INSTANCE);
        }

        @Override
        public byte[] getOutput(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            return this.getOutput(workspace);
        }

        protected byte[] getOutput(FilePath workspace) throws IOException, InterruptedException {
            return (byte[])this.getOutputFile(workspace).act((FilePath.FileCallable)new MasterToSlaveFileCallable<byte[]>(){

                public byte[] invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    byte[] buf = FileUtils.readFileToByteArray((File)f);
                    ByteBuffer transcoded = FileMonitoringController.maybeTranscode(buf, FileMonitoringController.this.charset);
                    if (transcoded == null) {
                        return buf;
                    }
                    byte[] buf2 = new byte[transcoded.remaining()];
                    transcoded.get(buf2);
                    return buf2;
                }
            });
        }

        @CheckForNull
        private static ByteBuffer maybeTranscode(@Nonnull byte[] data, @CheckForNull String charset) {
            Charset cs = FileMonitoringController.transcodingCharset(charset);
            if (cs == null) {
                return null;
            }
            return StandardCharsets.UTF_8.encode(cs.decode(ByteBuffer.wrap(data)));
        }

        @CheckForNull
        private static Charset transcodingCharset(@CheckForNull String charset) {
            Charset cs;
            if (charset == null) {
                return null;
            }
            Charset charset2 = cs = charset.equals(FileMonitoringTask.SYSTEM_DEFAULT_CHARSET) ? Charset.defaultCharset() : Charset.forName(charset);
            if (cs.equals(StandardCharsets.UTF_8)) {
                return null;
            }
            return cs;
        }

        @Override
        public final void stop(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            launcher.kill(Collections.singletonMap(FileMonitoringTask.COOKIE, FileMonitoringTask.cookieFor(workspace)));
        }

        @Override
        public void cleanup(FilePath workspace) throws IOException, InterruptedException {
            this.controlDir(workspace).deleteRecursive();
        }

        public FilePath controlDir(FilePath ws) throws IOException, InterruptedException {
            if (this.controlDir != null) {
                return ws.child(this.controlDir);
            }
            assert (this.id != null);
            FilePath cd = ws.child("." + this.id);
            if (!cd.isDirectory()) {
                cd = ws.child(".jenkins-" + this.id);
            }
            this.controlDir = cd.getRemote();
            this.id = null;
            LOGGER.info("using migrated control directory " + this.controlDir + " for remainder of this task");
            return cd;
        }

        private static FilePath tempDir(FilePath ws) {
            return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
        }

        public FilePath getResultFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("jenkins-result.txt");
        }

        public FilePath getLogFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("jenkins-log.txt");
        }

        public FilePath getOutputFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("output.txt");
        }

        @Override
        public String getDiagnostics(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            FilePath cd = this.controlDir(workspace);
            VirtualChannel channel = cd.getChannel();
            String node = channel instanceof Channel ? ((Channel)channel).getName() : null;
            String location = node != null ? cd.getRemote() + " on " + node : cd.getRemote();
            StringWriter w = new StringWriter();
            Integer code = this.exitStatus(workspace, launcher, (TaskListener)new StreamTaskListener((Writer)w));
            if (code != null) {
                return w + "completed process (code " + code + ") in " + location;
            }
            return w + "awaiting process completion in " + location;
        }

        @Override
        public void watch(FilePath workspace, Handler handler, TaskListener listener) throws IOException, InterruptedException, ClassCastException {
            workspace.actAsync((FilePath.FileCallable)new StartWatching(this, handler, listener));
            LOGGER.log(Level.FINE, "started asynchronous watch in {0}", this.controlDir);
        }

        public FilePath getLastLocationFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("last-location.txt");
        }

        static class StatusCheck
        extends MasterToSlaveFileCallable<Integer> {
            StatusCheck() {
            }

            @CheckForNull
            public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                if (f.exists() && f.length() > 0L) {
                    try {
                        String fileString = Files.readFirstLine((File)f, (Charset)Charset.defaultCharset());
                        if (fileString == null || fileString.isEmpty()) {
                            return null;
                        }
                        if ((fileString = fileString.trim()).isEmpty()) {
                            return null;
                        }
                        return Integer.parseInt(fileString);
                    }
                    catch (NumberFormatException x) {
                        throw new IOException("corrupted content in " + f + ": " + x, x);
                    }
                }
                return null;
            }
        }

        private static class TranscodingCharsetForSystemDefault
        extends MasterToSlaveCallable<String, RuntimeException> {
            private TranscodingCharsetForSystemDefault() {
            }

            public String call() throws RuntimeException {
                Charset cs = FileMonitoringController.transcodingCharset(FileMonitoringTask.SYSTEM_DEFAULT_CHARSET);
                return cs != null ? cs.name() : null;
            }
        }

        private static class WriteLog
        extends MasterToSlaveFileCallable<Void> {
            private final long lastLocation;
            private final OutputStream sink;

            WriteLog(long lastLocation, OutputStream sink) {
                this.lastLocation = lastLocation;
                this.sink = sink;
            }

            public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                long len = f.length();
                if (len > this.lastLocation) {
                    try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
                        raf.seek(this.lastLocation);
                        long toRead = len - this.lastLocation;
                        if (toRead > Integer.MAX_VALUE) {
                            throw new IOException("large reads not yet implemented");
                        }
                        byte[] buf = new byte[(int)toRead];
                        raf.readFully(buf);
                        this.sink.write(buf);
                    }
                }
                return null;
            }
        }
    }
}

