/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook.dockerregistry;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.registry.notification.webhook.WebHookPayload;
import org.jenkinsci.plugins.registry.notification.webhook.dockerregistry.DockerRegistryPushNotification;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DockerRegistryWebHookPayload
extends WebHookPayload {
    private static final Logger logger = Logger.getLogger(DockerRegistryPushNotification.class.getName());

    public DockerRegistryWebHookPayload(@NonNull JSONObject data) {
        this.setData(data);
        this.setJson(data.toString());
        JSONArray events = data.getJSONArray("events");
        int size = events.size();
        for (int i = 0; i < size; ++i) {
            JSONObject event = events.getJSONObject(i);
            String separator = "/";
            if (event.optString("action").equals("push")) {
                String[] urlSegments = event.getJSONObject("target").optString("url").split(separator);
                StringBuffer sb = new StringBuffer();
                sb.append(urlSegments[2]);
                sb.append(separator);
                sb.append(event.getJSONObject("target").optString("repository"));
                String repository = sb.toString();
                if (urlSegments[urlSegments.length - 2].equals("manifests")) {
                    this.pushNotifications.add(this.createPushNotification(repository, event));
                    continue;
                }
                logger.log(Level.FINER, "Skipping Layer Push notifications");
                continue;
            }
            logger.log(Level.FINER, "Skipping pull notification" + event.getJSONObject("target").optString("repository"));
        }
    }

    private DockerRegistryPushNotification createPushNotification(@NonNull String repoName, @NonNull JSONObject data) {
        final String timestamp = data.optString("timestamp");
        final String host = data.getJSONObject("request").optString("host");
        final String tag = data.getJSONObject("target").optString("tag");
        return new DockerRegistryPushNotification(this, repoName){
            {
                super(webHookPayload, repoName);
                DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
                this.setTag(tag);
                this.setPushedAt(parser.parseDateTime(timestamp).toDate());
                this.setRegistryHost(host);
            }
        };
    }
}

