/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook.dockerhub;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.registry.notification.TriggerStore;
import org.jenkinsci.plugins.registry.notification.webhook.CallbackHandler;
import org.jenkinsci.plugins.registry.notification.webhook.Http;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;
import org.jenkinsci.plugins.registry.notification.webhook.WebHookPayload;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubCallbackPayload;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubPushNotification;

public class DockerHubWebHookPayload
extends WebHookPayload {
    private static final Logger logger = Logger.getLogger(DockerHubWebHookPayload.class.getName());
    private Date pushedAt = null;

    public DockerHubWebHookPayload(@NonNull String repoName, @CheckForNull JSONObject data) {
        this.setData(data);
        if (data != null) {
            this.setJson(data.toString());
        }
        this.pushNotifications.add(this.createPushNotification(repoName, data));
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.pushNotifications == null || this.pushNotifications.isEmpty()) {
            this.pushNotifications = new ArrayList();
            String repoName = "";
            JSONObject data = this.getData();
            if (data != null) {
                JSONObject repository = data.optJSONObject("repository");
                if (repository != null && repository.has("repo_name")) {
                    repoName = repository.getString("repo_name");
                }
                this.pushNotifications.add(this.createPushNotification(repoName, data));
            }
        }
        return this;
    }

    public DockerHubWebHookPayload(@NonNull JSONObject data) {
        this.setData(data);
        if (data != null) {
            this.setJson(data.toString());
        }
        JSONObject repository = data.getJSONObject("repository");
        this.pushNotifications.add(this.createPushNotification(repository.getString("repo_name"), data));
    }

    private DockerHubPushNotification createPushNotification(@NonNull String repoName, @CheckForNull JSONObject data) {
        DockerHubPushNotification dockerHubPushNotification = new DockerHubPushNotification(this, repoName);
        if (data != null) {
            dockerHubPushNotification.setCallbackUrl(data.optString("callback_url"));
            JSONObject push_data = data.optJSONObject("push_data");
            if (push_data != null) {
                try {
                    long pushed_at = push_data.optLong("pushed_at");
                    if (pushed_at > 0L) {
                        dockerHubPushNotification.setPushedAt(new Date(pushed_at * 1000L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dockerHubPushNotification.setCallbackHandler(new WebHookPayloadCallback(dockerHubPushNotification));
        }
        return dockerHubPushNotification;
    }

    public DockerHubWebHookPayload(@NonNull String repoName) {
        this(repoName, null);
    }

    public static final class WebHookPayloadCallback
    implements CallbackHandler {
        final DockerHubPushNotification dockerHubPushNotification;

        public WebHookPayloadCallback(DockerHubPushNotification dockerHubPushNotification) {
            this.dockerHubPushNotification = dockerHubPushNotification;
        }

        @Override
        public void notify(PushNotification pushNotification, Run<?, ?> run) throws InterruptedException, ExecutionException, IOException {
            DockerHubCallbackPayload callback;
            String callbackUrl = this.dockerHubPushNotification.getCallbackUrl();
            TriggerStore.TriggerEntry entry = TriggerStore.getInstance().finalized(this.dockerHubPushNotification, run);
            if (entry != null && (callback = DockerHubCallbackPayload.from(entry)) != null) {
                if (!StringUtils.isBlank((String)callbackUrl)) {
                    logger.log(Level.FINE, "Sending callback to Docker Hub");
                    logger.log(Level.FINER, "Callback: {0}", callback);
                    int response = Http.post(callbackUrl, callback.toJSON());
                    logger.log(Level.FINE, "Docker Hub returned {0}", response);
                    return;
                }
                logger.log(Level.WARNING, "No callback URL specified in {0}", pushNotification);
            }
            logger.log(Level.WARNING, "Failed to prepare Docker Hub callback payload for {0}", pushNotification);
        }
    }
}

