/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook.dockerhub;

import hudson.Extension;
import hudson.Main;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.registry.notification.webhook.JSONWebHook;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;
import org.jenkinsci.plugins.registry.notification.webhook.WebHookPayload;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubWebHookPayload;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class DockerHubWebHook
extends JSONWebHook {
    private static final Logger logger = Logger.getLogger(DockerHubWebHook.class.getName());
    public static final String URL_NAME = "dockerhub-webhook";

    private boolean isDebugMode() {
        if (Main.isDevelopmentMode || Main.isUnitTest) {
            return true;
        }
        return System.getProperty("hudson.hpi.run") != null;
    }

    public void doDebug(@QueryParameter(required=true) String image, StaplerResponse response) throws IOException {
        if (!this.isDebugMode()) {
            throw new IllegalStateException("This endpoint can only be used during development!");
        }
        DockerHubWebHookPayload dockerHubWebHookPayload = new DockerHubWebHookPayload(image);
        for (PushNotification pushNotification : dockerHubWebHookPayload.getPushNotifications()) {
            this.trigger(response, pushNotification);
        }
    }

    @Override
    protected void trigger(StaplerResponse response, PushNotification pushNotification) throws IOException {
        super.trigger(response, pushNotification);
        response.sendRedirect("../");
    }

    @Override
    protected WebHookPayload createPushNotification(JSONObject payload) {
        return new DockerHubWebHookPayload(payload);
    }

    public String getUrlName() {
        return URL_NAME;
    }
}

