/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook.dockerhub;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubWebHookCause;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubWebHookPayload;

public class DockerHubPushNotification
extends PushNotification {
    private static final long serialVersionUID = 207798312860576090L;
    public static final String KEY_REPO_NAME = "DOCKER_TRIGGER_REPO_NAME";
    public static final String KEY_DOCKER_HUB_HOST = "DOCKER_TRIGGER_DOCKER_HUB_HOST";
    public static final String KEY_PUSHER = "DOCKER_TRIGGER_PUSHER";
    public static final String KEY_TAG = "DOCKER_TRIGGER_TAG";
    private static final Logger logger = Logger.getLogger(DockerHubPushNotification.class.getName());
    private String callbackUrl;

    public DockerHubPushNotification(DockerHubWebHookPayload webHookPayload, String repoName) {
        super(webHookPayload);
        this.repoName = repoName;
    }

    @CheckForNull
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Override
    @CheckForNull
    public String getRegistryHost() {
        String urlS = this.getCallbackUrl();
        if (urlS != null) {
            try {
                URL url = new URL(urlS);
                return url.getHost();
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "DockerHub is sending malformed data. ", e);
            }
        }
        return null;
    }

    @CheckForNull
    public String getPusher() {
        JSONObject push_data;
        JSONObject data = this.getWebHookPayload().getData();
        if (data != null && (push_data = data.optJSONObject("push_data")) != null) {
            return push_data.optString("pusher");
        }
        return null;
    }

    @CheckForNull
    public String getTag() {
        JSONObject push_data;
        JSONObject data = this.getWebHookPayload().getData();
        if (data != null && (push_data = data.optJSONObject("push_data")) != null) {
            return push_data.optString("tag");
        }
        return null;
    }

    @Override
    public Cause getCause() {
        return new DockerHubWebHookCause(this);
    }

    @Override
    public Set<ParameterValue> getRunParameters() {
        String pusher;
        String tag;
        HashSet<ParameterValue> parameters = new HashSet<ParameterValue>();
        parameters.add((ParameterValue)new StringParameterValue(KEY_REPO_NAME, this.getRepoName()));
        String host = this.getRegistryHost();
        if (!StringUtils.isBlank((String)host)) {
            parameters.add((ParameterValue)new StringParameterValue(KEY_DOCKER_HUB_HOST, host));
        }
        if (!StringUtils.isBlank((String)(tag = this.getTag()))) {
            parameters.add((ParameterValue)new StringParameterValue(KEY_TAG, tag));
        }
        if (!StringUtils.isBlank((String)(pusher = this.getPusher()))) {
            parameters.add((ParameterValue)new StringParameterValue(KEY_PUSHER, pusher));
        }
        return parameters;
    }

    @Override
    public String getCauseMessage() {
        return "Docker image " + this.getRepoName() + " has been rebuilt by DockerHub@" + this.getRegistryHost();
    }

    @Override
    public String sha() {
        return Util.getDigestOf((String)("dockerHubNotification:" + this.repoName + Long.toBinaryString(this.getReceived())));
    }

    @Override
    public String getShortDescription() {
        return String.format("push of %s to DockerHub@%s", this.getRepoName(), this.getRegistryHost());
    }
}

