/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook.acr;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.registry.notification.webhook.WebHookPayload;
import org.jenkinsci.plugins.registry.notification.webhook.acr.ACRPushNotification;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ACRWebHookPayload
extends WebHookPayload {
    private static final Logger logger = Logger.getLogger(ACRWebHookPayload.class.getName());

    public ACRWebHookPayload(@NonNull JSONObject data) {
        this.setData(data);
        this.setJson(data.toString());
        if (Action.PUSH.getName().equals(data.optString("action"))) {
            final JSONObject event = data;
            final String host = event.getJSONObject("request").getString("host");
            String url = host + "/" + event.getJSONObject("target").getString("repository");
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Creating push notification for " + url);
            }
            this.pushNotifications.add(new ACRPushNotification(this, url){
                {
                    super(webHookPayload, repoName);
                    DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
                    this.setPushedAt(parser.parseDateTime(event.getString("timestamp")).toDate());
                    this.setRegistryHost(host);
                }
            });
        } else {
            logger.log(Level.FINER, "Unsupported event received: " + data.toString());
        }
    }

    public static enum Action {
        PUSH("push");

        private String name;

        private Action(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

