/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import hudson.model.Run;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.jenkinsci.plugins.registry.notification.webhook.CallbackHandler;
import org.jenkinsci.plugins.registry.notification.webhook.WebHookPayload;

public abstract class PushNotification {
    private final WebHookPayload webHookPayload;
    protected String repoName;
    private Date pushedAt;
    CallbackHandler callbackHandler = new CallbackHandler(){

        @Override
        public void notify(PushNotification pushNotification, Run<?, ?> run) {
        }
    };

    public PushNotification(WebHookPayload webHookPayload) {
        this.webHookPayload = webHookPayload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushNotification that = (PushNotification)o;
        if (this.webHookPayload != null ? !this.webHookPayload.equals(that.webHookPayload) : that.webHookPayload != null) {
            return false;
        }
        if (this.repoName != null ? !this.repoName.equals(that.repoName) : that.repoName != null) {
            return false;
        }
        return !(this.pushedAt == null ? that.pushedAt != null : !this.pushedAt.equals(that.pushedAt));
    }

    public int hashCode() {
        int result = this.webHookPayload != null ? this.webHookPayload.hashCode() : 0;
        result = 31 * result + (this.repoName != null ? this.repoName.hashCode() : 0);
        result = 31 * result + (this.pushedAt != null ? this.pushedAt.hashCode() : 0);
        return result;
    }

    public abstract Cause getCause();

    @Deprecated
    public Set<ParameterValue> getJobParamerers() {
        if (Util.isOverridden(PushNotification.class, this.getClass(), (String)"getRunParameters", (Class[])new Class[0])) {
            return this.getRunParameters();
        }
        return Collections.emptySet();
    }

    public Set<ParameterValue> getRunParameters() {
        if (Util.isOverridden(PushNotification.class, this.getClass(), (String)"getJobParamerers", (Class[])new Class[0])) {
            return this.getJobParamerers();
        }
        return Collections.emptySet();
    }

    public abstract String getCauseMessage();

    public String getRepoName() {
        return this.repoName;
    }

    public abstract String sha();

    @CheckForNull
    public Date getPushedAt() {
        return new Date(this.pushedAt.getTime());
    }

    public void setPushedAt(Date pushedAt) {
        this.pushedAt = new Date(pushedAt.getTime());
    }

    public WebHookPayload getWebHookPayload() {
        return this.webHookPayload;
    }

    public long getReceived() {
        return this.webHookPayload.getReceived();
    }

    public abstract String getShortDescription();

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public abstract String getRegistryHost();
}

