/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.webhook;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.registry.notification.Coordinator;
import org.jenkinsci.plugins.registry.notification.DockerHubTrigger;
import org.jenkinsci.plugins.registry.notification.TriggerStore;
import org.jenkinsci.plugins.registry.notification.token.ApiTokens;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;
import org.jenkinsci.plugins.registry.notification.webhook.ResultPage;
import org.jenkinsci.plugins.registry.notification.webhook.WebHookPayload;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.interceptor.RespondSuccess;
import org.springframework.security.access.AccessDeniedException;

public abstract class JSONWebHook
implements UnprotectedRootAction {
    private static final Logger logger = Logger.getLogger(JSONWebHook.class.getName());
    private static boolean DO_NOT_REQUIRE_API_TOKEN = SystemProperties.getBoolean((String)(JSONWebHook.class.getName() + "DO_NOT_REQUIRE_API_TOKEN"));

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "DockerHub web hook";
    }

    @RequirePOST
    @RespondSuccess
    public void doNotify(@QueryParameter(required=false) String payload, StaplerRequest request, StaplerResponse response) throws IOException {
        if (!DO_NOT_REQUIRE_API_TOKEN) {
            this.checkValidApiToken(request, response);
        }
        WebHookPayload hookPayload = null;
        if (payload != null) {
            try {
                hookPayload = this.createPushNotification(JSONObject.fromObject((Object)payload));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not parse the web hook payload!", e);
            }
        } else {
            hookPayload = this.parse(request);
        }
        if (hookPayload != null) {
            for (PushNotification pushNotification : hookPayload.getPushNotifications()) {
                try {
                    this.trigger(response, pushNotification);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Could not trigger a job!", e);
                }
            }
        }
    }

    private void checkValidApiToken(StaplerRequest request, StaplerResponse response) throws IOException {
        Ancestor ancestor = request.findAncestor(ValidApiToken.class);
        if (ancestor == null) {
            response.sendError(403, "No valid API token provided.");
            throw new AccessDeniedException("No valid API token provided.");
        }
    }

    public ValidApiToken getDynamic(String token, StaplerResponse rsp) throws IOException {
        if (ApiTokens.get().isValidApiToken(token)) {
            return new ValidApiToken(token, this);
        }
        rsp.sendError(403, "No valid API token provided.");
        return null;
    }

    @NonNull
    public ResultPage getDetails(@NonNull String sha) throws IOException, InterruptedException {
        TriggerStore.TriggerEntry entry = TriggerStore.getInstance().getEntry(sha);
        if (entry != null) {
            return new ResultPage(entry);
        }
        return ResultPage.NO_RESULT;
    }

    protected void trigger(StaplerResponse response, final PushNotification pushNotification) throws IOException {
        final Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return;
        }
        ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new Runnable(){

            @Override
            public void run() {
                for (ParameterizedJobMixIn.ParameterizedJob p : jenkins.getAllItems(ParameterizedJobMixIn.ParameterizedJob.class)) {
                    String repoName;
                    DockerHubTrigger trigger = DockerHubTrigger.getTrigger(p);
                    if (trigger == null) {
                        logger.log(Level.FINER, "job {0} doesn't have DockerHubTrigger set", p.getName());
                        continue;
                    }
                    logger.log(Level.FINER, "Inspecting candidate job {0}", p.getName());
                    Set<String> allRepoNames = trigger.getAllRepoNames();
                    if (!allRepoNames.contains(repoName = pushNotification.getRepoName())) continue;
                    JSONWebHook.this.schedule((Job)p, pushNotification);
                }
            }
        });
    }

    private void schedule(@NonNull Job job, @NonNull PushNotification pushNotification) {
        if (new JobbMixIn(job).schedule(pushNotification.getCause())) {
            logger.info(pushNotification.getCauseMessage());
            Coordinator coordinator = Coordinator.getInstance();
            if (coordinator != null) {
                coordinator.onTriggered(job, pushNotification);
            }
        }
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        response.sendRedirect(request.getContextPath() + "/");
    }

    protected abstract WebHookPayload createPushNotification(JSONObject var1);

    private WebHookPayload parse(StaplerRequest req) throws IOException {
        String body = IOUtils.toString((InputStream)req.getInputStream(), (String)req.getCharacterEncoding());
        String contentType = req.getContentType();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            body = URLDecoder.decode(body, req.getCharacterEncoding());
        }
        logger.log(Level.FINER, "Received commit hook notification : {0}", body);
        try {
            JSONObject payload = JSONObject.fromObject((Object)body);
            return this.createPushNotification(payload);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not parse the web hook payload!", e);
            return null;
        }
    }

    public static class ValidApiToken {
        private final String token;
        private final JSONWebHook delegate;

        public ValidApiToken(String token, JSONWebHook delegate) {
            this.token = token;
            this.delegate = delegate;
        }

        public String getToken() {
            return this.token;
        }

        @RequirePOST
        @RespondSuccess
        public void doNotify(@QueryParameter(required=false) String payload, StaplerRequest request, StaplerResponse response) throws IOException {
            this.delegate.doNotify(payload, request, response);
        }
    }

    static class JobbMixIn<JobT extends Job<JobT, RunT> & Queue.Task, RunT extends Run<JobT, RunT>>
    extends ParameterizedJobMixIn<JobT, RunT> {
        public static final int MIN_QUIET = 3;
        private JobT the;

        JobbMixIn(JobT the) {
            this.the = the;
        }

        protected JobT asJob() {
            return this.the;
        }

        boolean schedule(Cause cause) {
            if (!((ParameterizedJobMixIn.ParameterizedJob)this.asJob()).isBuildable()) {
                return false;
            }
            LinkedList<Object> queueActions = new LinkedList<Object>();
            queueActions.add(new ParametersAction(this.getParameterValues()));
            queueActions.add(new CauseAction(cause));
            int quiet = Math.max(3, ((ParameterizedJobMixIn.ParameterizedJob)this.asJob()).getQuietPeriod());
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                logger.log(Level.WARNING, "Tried to schedule a build while Jenkins was gone.");
                return false;
            }
            Queue queue = jenkins.getQueue();
            if (queue == null) {
                throw new IllegalStateException("The queue is not initialized?!");
            }
            Queue.Item i = queue.schedule2((Queue.Task)this.asJob(), quiet, queueActions).getItem();
            return i != null && i.getFuture() != null;
        }

        private List<ParameterValue> getParameterValues() {
            HashSet<ParameterValue> result = new HashSet<ParameterValue>();
            if (this.isParameterized()) {
                result.addAll(this.getDefaultParametersValues());
            }
            return Collections.unmodifiableList(new LinkedList(result));
        }

        private List<ParameterValue> getDefaultParametersValues() {
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)this.asJob().getProperty(ParametersDefinitionProperty.class);
            ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
            if (paramDefProp == null) {
                return defValues;
            }
            for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
                ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
                if (defaultValue == null) continue;
                defValues.add(defaultValue);
            }
            return defValues;
        }
    }
}

