/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification.opt.impl;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.registry.notification.Messages;
import org.jenkinsci.plugins.registry.notification.opt.TriggerOption;
import org.jenkinsci.plugins.registry.notification.opt.TriggerOptionDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class TriggerOnSpecifiedImageNames
extends TriggerOption {
    private Set<String> repoNames;

    @DataBoundConstructor
    public TriggerOnSpecifiedImageNames() {
        this.repoNames = Collections.emptySet();
    }

    public TriggerOnSpecifiedImageNames(Collection<String> repoNames) {
        this.repoNames = new HashSet<String>();
        if (repoNames != null) {
            this.repoNames.addAll(repoNames);
        }
    }

    public TriggerOnSpecifiedImageNames(String ... repoNames) {
        this(Arrays.asList(repoNames));
    }

    public Set<String> getRepoNames() {
        return this.repoNames;
    }

    @DataBoundSetter
    public void setRepoNames(Set<String> repoNames) {
        this.repoNames = repoNames;
    }

    @Override
    public Collection<String> getRepoNames(Job<?, ?> job) {
        return this.getRepoNames();
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerOptionDescriptor {
        public String getDisplayName() {
            return Messages.TriggerOption_TriggerOnSpecifiedImageNames_DisplayName();
        }

        public TriggerOption newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.has("repoNames") && !StringUtils.isBlank((String)formData.optString("repoNames"))) {
                JSONArray array = new JSONArray();
                array.addAll(Arrays.asList(StringUtils.split((String)formData.getString("repoNames"))));
                formData.put("repoNames", (Object)array);
            } else {
                formData.put("repoNames", (Object)new JSONArray());
            }
            return (TriggerOption)super.newInstance(req, formData);
        }
    }
}

