/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.util.FormValidation;
import hudson.views.ViewJobFilter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.registry.notification.DockerHubTrigger;
import org.jenkinsci.plugins.registry.notification.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TriggerViewFilter
extends ViewJobFilter {
    @NonNull
    private List<String> patterns;
    private transient List<Pattern> compiled;

    @DataBoundConstructor
    public TriggerViewFilter(@NonNull List<String> patterns) throws Descriptor.FormException {
        this.patterns = patterns;
        try {
            this.compilePatterns();
        }
        catch (PatternSyntaxException e) {
            throw new Descriptor.FormException(Messages.TriggerViewFilter_CompileError(), (Throwable)e, "patterns");
        }
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        List<Pattern> patterns = this.getCompiled();
        List<TopLevelItem> workList = added.isEmpty() ? all : added;
        LinkedList<TopLevelItem> filtered = new LinkedList<TopLevelItem>();
        for (TopLevelItem item : workList) {
            DockerHubTrigger trigger;
            if (!(item instanceof ParameterizedJobMixIn.ParameterizedJob) || (trigger = DockerHubTrigger.getTrigger((ParameterizedJobMixIn.ParameterizedJob)item)) == null) continue;
            if (patterns.isEmpty()) {
                filtered.add(item);
                continue;
            }
            for (String name : trigger.getAllRepoNames()) {
                if (!this.matches(name)) continue;
                filtered.add(item);
            }
        }
        return filtered;
    }

    private boolean matches(String name) {
        List<Pattern> patterns = this.getCompiled();
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    synchronized List<Pattern> getCompiled() {
        this.compilePatterns();
        return this.compiled;
    }

    private synchronized void compilePatterns() {
        if (this.compiled == null) {
            this.compiled = TriggerViewFilter.compilePatterns(this.patterns);
        }
    }

    @NonNull
    private static List<Pattern> compilePatterns(@NonNull List<String> strings) {
        LinkedList<Pattern> comp = new LinkedList<Pattern>();
        for (String pattern : strings) {
            comp.add(Pattern.compile(pattern));
        }
        return comp;
    }

    @NonNull
    public synchronized List<String> getPatterns() {
        return this.patterns;
    }

    @Extension
    @Symbol(value={"dockerTriggers"})
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.TriggerViewFilter_DisplayName();
        }

        public ViewJobFilter newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.has("patterns") && !StringUtils.isBlank((String)formData.optString("patterns"))) {
                JSONArray array = new JSONArray();
                String[] split = StringUtils.split((String)formData.getString("patterns"), (char)'\n');
                if (split != null && split.length > 0) {
                    array.addAll(Arrays.asList(split));
                }
                formData.put("patterns", (Object)array);
            } else {
                formData.put("patterns", (Object)new JSONArray());
            }
            return (ViewJobFilter)super.newInstance(req, formData);
        }

        public FormValidation doCheckPatterns(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            String[] split = StringUtils.split((String)value, (char)'\n');
            try {
                TriggerViewFilter.compilePatterns(Arrays.asList(split));
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((Throwable)e, (String)Messages.TriggerViewFilter_CompileError());
            }
        }
    }
}

