/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.security.ACL;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.FingerprintFacet;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubCallbackPayload;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubWebHookPayload;

@Extension
public final class TriggerStore
extends Descriptor<TriggerStore>
implements Describable<TriggerStore> {
    @Inject
    Jenkins jenkins;
    private static final Logger logger = Logger.getLogger(TriggerStore.class.getName());

    public TriggerStore() {
        super(TriggerStore.class);
    }

    public synchronized void triggered(@NonNull PushNotification pushNotification, Job<?, ?> job) {
        try {
            TriggerEntry entry = this.getOrCreateEntry(pushNotification);
            entry.addEntry(job);
            this.save(entry);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to update triggered info for " + job.getFullDisplayName(), e);
        }
    }

    public synchronized void started(@NonNull PushNotification pushNotification, Run<?, ?> run) {
        try {
            TriggerEntry entry = this.getOrCreateEntry(pushNotification);
            entry.updateEntry(run);
            this.save(entry);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to update started info for " + run.getFullDisplayName(), e);
        }
    }

    @CheckForNull
    public synchronized TriggerEntry finalized(@NonNull PushNotification pushNotification, Run<?, ?> run) {
        try {
            TriggerEntry entry = this.getOrCreateEntry(pushNotification);
            entry.updateEntry(run);
            this.save(entry);
            return entry;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to update finalized info for " + run.getFullDisplayName(), e);
            return null;
        }
    }

    public synchronized void removed(@NonNull PushNotification payload, Run<?, ?> run) {
        try {
            TriggerEntry entry = this.getEntry(payload.sha());
            if (entry != null) {
                entry.removeEntry(run);
                if (entry.getEntries().isEmpty()) {
                    // empty if block
                }
                this.save(entry);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to remove info for build " + run.getFullDisplayName(), e);
        }
    }

    @NonNull
    private synchronized TriggerEntry getOrCreateEntry(@NonNull PushNotification pushNotification) throws IOException, InterruptedException {
        Fingerprint fingerprint = this.jenkins.getFingerprintMap().getOrCreate(null, pushNotification.getRepoName(), pushNotification.sha());
        TriggerEntry entry = (TriggerEntry)fingerprint.getFacet(TriggerEntry.class);
        if (entry == null) {
            entry = new TriggerEntry(fingerprint, pushNotification);
            fingerprint.getFacets().add(entry);
        }
        return entry;
    }

    @CheckForNull
    public synchronized TriggerEntry getEntry(String sha) throws IOException, InterruptedException {
        Fingerprint fingerprint = (Fingerprint)this.jenkins.getFingerprintMap().get(sha);
        if (fingerprint == null) {
            return null;
        }
        return (TriggerEntry)fingerprint.getFacet(TriggerEntry.class);
    }

    private synchronized void onLocationChanged(@NonNull Job<?, ?> item, @NonNull String oldFullName, @NonNull String newFullName) {
    }

    public synchronized void save(@NonNull TriggerEntry entry) throws IOException, InterruptedException {
        entry.getFingerprint().save();
    }

    @NonNull
    public static TriggerStore getInstance() {
        TriggerStore d;
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            d = null;
        } else {
            if (instance.getInitLevel().compareTo((Enum)InitMilestone.JOB_LOADED) < 0) {
                throw new AssertionError((Object)(TriggerStore.class.getName() + " is not available until after all jobs are loaded"));
            }
            d = (TriggerStore)instance.getDescriptorByType(TriggerStore.class);
        }
        if (d == null) {
            throw new AssertionError((Object)(TriggerStore.class.getName() + " is missing"));
        }
        return d;
    }

    public Descriptor<TriggerStore> getDescriptor() {
        return this;
    }

    @Extension
    public static class ItemListener
    extends hudson.model.listeners.ItemListener {
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            if (item instanceof Job) {
                TriggerStore.getInstance().onLocationChanged((Job)item, oldFullName, newFullName);
            }
        }
    }

    public static class TriggerEntry
    extends FingerprintFacet {
        @NonNull
        private PushNotification pushNotification;
        @NonNull
        private final List<RunEntry> entries;
        @CheckForNull
        private DockerHubCallbackPayload callbackData;
        private transient DockerHubWebHookPayload payload;

        public TriggerEntry(Fingerprint fingerprint, @NonNull PushNotification pushNotification) {
            super(fingerprint, pushNotification.getReceived());
            this.pushNotification = pushNotification;
            this.entries = new LinkedList<RunEntry>();
        }

        @NonNull
        public RunEntry addEntry(Job<?, ?> job) {
            RunEntry entry = this.getEntry(job.getFullName());
            if (entry == null) {
                entry = new RunEntry(job.getFullName());
            }
            return entry;
        }

        public RunEntry getEntry(@NonNull Job<?, ?> job) {
            return this.getEntry(job.getFullName());
        }

        public RunEntry getEntry(@NonNull String jobName) {
            for (RunEntry entry : this.entries) {
                if (!entry.getJobName().equals(jobName)) continue;
                return entry;
            }
            return null;
        }

        public RunEntry updateEntry(Run<?, ?> run) {
            RunEntry entry = this.getEntry(run.getParent());
            if (entry == null) {
                entry = new RunEntry(run.getParent().getFullName(), run.getId());
                this.entries.add(entry);
            } else {
                entry.setRun(run);
            }
            entry.setDone(!run.isBuilding());
            return entry;
        }

        @NonNull
        public PushNotification getPushNotification() {
            return this.pushNotification;
        }

        @NonNull
        public List<RunEntry> getEntries() {
            return this.entries;
        }

        @CheckForNull
        public DockerHubCallbackPayload getCallbackData() {
            return this.callbackData;
        }

        public void setCallbackData(@CheckForNull DockerHubCallbackPayload callbackData) {
            this.callbackData = callbackData;
        }

        public void removeEntry(@NonNull Run<?, ?> run) {
            RunEntry entry = this.getEntry(run.getParent());
            if (entry != null) {
                this.entries.remove(entry);
            }
        }

        public boolean areAllDone() {
            for (RunEntry entry : this.entries) {
                if (entry.isDone()) continue;
                return false;
            }
            return true;
        }

        public Object readResolve() {
            if (this.payload != null) {
                this.pushNotification = this.payload.getPushNotifications().get(0);
            }
            return this;
        }

        public static class RunEntry
        implements Serializable {
            private static final long serialVersionUID = -4889803337604416914L;
            private String jobName;
            private String buildId;
            private boolean done;

            public RunEntry(@NonNull String jobName) {
                this.jobName = jobName;
            }

            public RunEntry(@NonNull String jobName, String buildId) {
                this.jobName = jobName;
                this.buildId = buildId;
            }

            @NonNull
            public String getJobName() {
                return this.jobName;
            }

            public void setJobName(@NonNull String jobName) {
                this.jobName = jobName;
            }

            @CheckForNull
            public String getBuildId() {
                return this.buildId;
            }

            public boolean isDone() {
                return this.done;
            }

            public void setDone(boolean done) {
                this.done = done;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CheckForNull
            public Job<?, ?> getJob() {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins != null) {
                    SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
                    try {
                        Job job = (Job)jenkins.getItemByFullName(this.jobName, Job.class);
                        return job;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Unable to retrieve job " + this.jobName, e);
                    }
                    finally {
                        SecurityContextHolder.setContext((SecurityContext)old);
                    }
                }
                return null;
            }

            public void setRun(@CheckForNull Run<?, ?> build) {
                this.buildId = build == null ? null : build.getId();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CheckForNull
            public Run<?, ?> getRun() {
                if (StringUtils.isBlank((String)this.buildId)) {
                    return null;
                }
                Job<?, ?> job = this.getJob();
                if (job != null) {
                    SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
                    try {
                        Run run = job.getBuild(this.buildId);
                        return run;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Unable to retrieve run " + this.jobName + ":" + this.buildId, e);
                    }
                    finally {
                        SecurityContextHolder.setContext((SecurityContext)old);
                    }
                }
                return null;
            }
        }
    }
}

