/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification;

import hudson.Extension;
import hudson.model.TopLevelItem;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.registry.notification.DockerHubTrigger;
import org.jenkinsci.plugins.registry.notification.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TriggerListViewColumn
extends ListViewColumn {
    private int showMax = 0;

    @DataBoundConstructor
    public TriggerListViewColumn() {
    }

    public int getShowMax() {
        return this.showMax;
    }

    @DataBoundSetter
    public void setShowMax(int showMax) {
        this.showMax = showMax;
    }

    public String getColumnCaption() {
        return Messages.TriggerListViewColumn_ColumnCaption();
    }

    public Collection<String> getImageNames(TopLevelItem item) {
        DockerHubTrigger trigger;
        if (item instanceof ParameterizedJobMixIn.ParameterizedJob && (trigger = DockerHubTrigger.getTrigger((ParameterizedJobMixIn.ParameterizedJob)item)) != null) {
            Set<String> names = trigger.getAllRepoNames();
            if (this.showMax <= 0 || names.size() <= this.showMax) {
                return names;
            }
            String[] array = names.toArray(new String[names.size()]);
            return Arrays.asList(Arrays.copyOf(array, this.showMax));
        }
        return Collections.emptySet();
    }

    @Extension
    @Symbol(value={"dockerImageNames"})
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.TriggerListViewColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

