/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import hudson.util.XStream2;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.registry.notification.DockerPullImageBuilder;
import org.jenkinsci.plugins.registry.notification.Messages;
import org.jenkinsci.plugins.registry.notification.TriggerListViewColumn;
import org.jenkinsci.plugins.registry.notification.TriggerStore;
import org.jenkinsci.plugins.registry.notification.TriggerViewFilter;
import org.jenkinsci.plugins.registry.notification.opt.TriggerOption;
import org.jenkinsci.plugins.registry.notification.opt.TriggerOptionDescriptor;
import org.jenkinsci.plugins.registry.notification.opt.impl.TriggerForAllUsedInJob;
import org.jenkinsci.plugins.registry.notification.opt.impl.TriggerOnSpecifiedImageNames;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubWebHookCause;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class DockerHubTrigger
extends Trigger<Job<?, ?>> {
    private List<TriggerOption> options;

    @DataBoundConstructor
    public DockerHubTrigger(List<TriggerOption> options) {
        this.options = options;
    }

    public DockerHubTrigger(TriggerOption ... options) {
        this(Arrays.asList(options));
    }

    public void start(Job job, boolean newInstance) {
        this.job = job;
    }

    public List<TriggerOption> getOptions() {
        return this.options;
    }

    public DescribableList<TriggerOption, TriggerOptionDescriptor> getOptionsList() {
        return new DescribableList((Saveable)this.job, this.options != null ? this.options : Collections.emptyList());
    }

    @DataBoundSetter
    public void setOptions(List<TriggerOption> options) {
        this.options = options;
    }

    @NonNull
    public Set<String> getAllRepoNames() {
        HashSet<String> all = new HashSet<String>();
        if (this.options != null) {
            for (TriggerOption option : this.options) {
                all.addAll(option.getRepoNames((Job)this.job));
            }
        }
        return all;
    }

    @CheckForNull
    public static DockerHubTrigger getTrigger(ParameterizedJobMixIn.ParameterizedJob job) {
        DescriptorImpl descriptor;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (descriptor = (DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class)) != null) {
            Map triggers = job.getTriggers();
            return (DockerHubTrigger)((Object)triggers.get((Object)descriptor));
        }
        return null;
    }

    @Initializer(before=InitMilestone.JOB_LOADED)
    @Restricted(value={NoExternalUse.class})
    public static void packageRenameConverting() {
        for (XStream2 xs : Arrays.asList(Items.XSTREAM2, Run.XSTREAM2, Jenkins.XSTREAM2, DockerHubTrigger.getFingerprintXStream())) {
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.DockerHubTrigger", DockerHubTrigger.class);
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.DockerHubWebHookCause", DockerHubWebHookCause.class);
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.DockerPullImageBuilder", DockerPullImageBuilder.class);
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.TriggerListViewColumn", TriggerListViewColumn.class);
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.TriggerViewFilter", TriggerViewFilter.class);
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.opt.impl.TriggerForAllUsedInJob", TriggerForAllUsedInJob.class);
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.opt.impl.TriggerOnSpecifiedImageNames", TriggerOnSpecifiedImageNames.class);
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.TriggerStore$TriggerEntry", TriggerStore.TriggerEntry.class);
            xs.addCompatibilityAlias("org.jenkinsci.plugins.dockerhub.notification.TriggerStore$TriggerEntry$RunEntry", TriggerStore.TriggerEntry.RunEntry.class);
        }
    }

    @NonNull
    private static XStream2 getFingerprintXStream() {
        try {
            Field field = Fingerprint.class.getDeclaredField("XSTREAM");
            field.setAccessible(true);
            XStream2 xStream2 = (XStream2)field.get(null);
            if (xStream2 == null) {
                xStream2 = new XStream2();
            }
            return xStream2;
        }
        catch (NoSuchFieldException e) {
            Logger.getLogger(DockerHubTrigger.class.getName()).log(Level.WARNING, "Fingerprint XStream instance gone? Old data conversion of stored callback reports can't be performed. Risk of data loss.", e);
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(DockerHubTrigger.class.getName()).log(Level.WARNING, "Fingerprint XStream instance inaccessible due to installed security manager. Old data conversion of stored callback reports can't be performed. Risk of data loss.", e);
        }
        return new XStream2();
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DockerHubTrigger_DisplayName();
        }

        public Trigger<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject data = formData.getJSONObject("options");
            Vector<TriggerOption> r = new Vector<TriggerOption>();
            for (TriggerOptionDescriptor d : TriggerOptionDescriptor.all()) {
                String safeName = d.getJsonSafeClassName();
                if (req.getParameter(safeName) == null) continue;
                TriggerOption instance = (TriggerOption)d.newInstance(req, data.getJSONObject(safeName));
                r.add(instance);
            }
            return new DockerHubTrigger(r);
        }
    }
}

