/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.registry.notification;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.registry.notification.TriggerStore;
import org.jenkinsci.plugins.registry.notification.webhook.PushNotification;
import org.jenkinsci.plugins.registry.notification.webhook.WebHookCause;
import org.jenkinsci.plugins.registry.notification.webhook.dockerhub.DockerHubWebHookCause;

@Extension
public class Coordinator
extends RunListener<Run<?, ?>> {
    private static final Logger logger = Logger.getLogger(Coordinator.class.getName());

    public void onTriggered(@NonNull Job job, @NonNull PushNotification pushNotification) {
        logger.log(Level.FINER, "Job {0} triggered for payload: {1}", new Object[]{job.getFullDisplayName(), pushNotification});
        TriggerStore.getInstance().triggered(pushNotification, job);
    }

    public void onStarted(@NonNull Run<?, ?> run, @NonNull TaskListener listener) {
        DockerHubWebHookCause cause = (DockerHubWebHookCause)run.getCause(DockerHubWebHookCause.class);
        if (cause != null) {
            logger.log(Level.FINER, "Build {0} started for cause: {1}", new Object[]{run.getFullDisplayName(), cause});
            TriggerStore.getInstance().started(cause.getPushNotification(), run);
        }
    }

    public void onFinalized(@NonNull Run<?, ?> run) {
        WebHookCause cause = (WebHookCause)run.getCause(WebHookCause.class);
        if (cause != null) {
            logger.log(Level.FINER, "Build {0} done for cause: [{1}]", new Object[]{run.getFullDisplayName(), cause});
            TriggerStore.TriggerEntry entry = TriggerStore.getInstance().finalized(cause.getPushNotification(), run);
            if (entry != null) {
                if (entry.areAllDone()) {
                    logger.log(Level.FINE, "All builds for [{0}] are done, preparing callback to Docker Hub", (Object)cause);
                    try {
                        this.sendResponse(cause.getPushNotification(), run);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to update Docker Hub!", e);
                    }
                }
            } else {
                logger.log(Level.INFO, "Failed to do final evaluation of builds for cause [{0}]", (Object)cause);
            }
        }
    }

    private void sendResponse(@NonNull PushNotification pushNotification, Run<?, ?> run) throws IOException, ExecutionException, InterruptedException {
        pushNotification.getCallbackHandler().notify(pushNotification, run);
    }

    public void onDeleted(@NonNull Run<?, ?> run) {
        DockerHubWebHookCause cause = (DockerHubWebHookCause)run.getCause(DockerHubWebHookCause.class);
        if (cause != null) {
            TriggerStore.getInstance().removed(cause.getPushNotification(), run);
        }
    }

    @CheckForNull
    public static Coordinator getInstance() {
        ExtensionList list;
        Jenkins j = Jenkins.getInstance();
        if (j != null && (list = j.getExtensionList(Coordinator.class)) != null && !list.isEmpty()) {
            return (Coordinator)((Object)list.get(0));
        }
        return null;
    }
}

