/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Job;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.jenkinsci.plugins.docker.workflow.AbstractEndpointStepExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class ServerEndpointStep
extends AbstractStepImpl {
    @Nonnull
    private final DockerServerEndpoint server;

    @DataBoundConstructor
    public ServerEndpointStep(@Nonnull DockerServerEndpoint server) {
        assert (server != null);
        this.server = server;
    }

    public DockerServerEndpoint getServer() {
        return this.server;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "withDockerServer";
        }

        public String getDisplayName() {
            return "Sets up Docker server endpoint";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractEndpointStepExecution {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient ServerEndpointStep step;
        @StepContextParameter
        private transient Job<?, ?> job;
        @StepContextParameter
        private transient FilePath workspace;

        @Override
        protected KeyMaterialFactory newKeyMaterialFactory() throws IOException, InterruptedException {
            return this.step.server.newKeyMaterialFactory(this.job, this.workspace.getChannel());
        }
    }
}

