/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Node;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerFingerprints;
import org.jenkinsci.plugins.docker.workflow.ImageAction;
import org.jenkinsci.plugins.docker.workflow.client.DockerClient;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FromFingerprintStep
extends AbstractStepImpl {
    private final String dockerfile;
    private final String image;
    private String toolName;

    @DataBoundConstructor
    public FromFingerprintStep(String dockerfile, String image) {
        this.dockerfile = dockerfile;
        this.image = image;
    }

    public String getDockerfile() {
        return this.dockerfile;
    }

    public String getImage() {
        return this.image;
    }

    public String getToolName() {
        return this.toolName;
    }

    @DataBoundSetter
    public void setToolName(String toolName) {
        this.toolName = Util.fixEmpty((String)toolName);
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "dockerFingerprintFrom";
        }

        public String getDisplayName() {
            return "Record trace of a Docker image used in FROM";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient FromFingerprintStep step;
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Node node;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void run() throws Exception {
            String fromImage = null;
            FilePath dockerfile = this.workspace.child(this.step.dockerfile);
            try (InputStream is = dockerfile.read();
                 BufferedReader r = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));){
                String line;
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || !line.startsWith("FROM ")) continue;
                    fromImage = line.substring(5);
                    break;
                }
            }
            if (fromImage == null) {
                throw new AbortException("could not find FROM instruction in " + dockerfile);
            }
            DockerClient client = new DockerClient(this.launcher, this.node, this.step.toolName);
            String descendantImageId = client.inspectRequiredField(this.env, this.step.image, ".Id");
            if (fromImage.equals("scratch")) {
                DockerFingerprints.addFromFacet(null, (String)descendantImageId, (Run)this.run);
            } else {
                DockerFingerprints.addFromFacet((String)client.inspectRequiredField(this.env, fromImage, ".Id"), (String)descendantImageId, (Run)this.run);
                ImageAction.add(fromImage, this.run);
            }
            return null;
        }
    }
}

