/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow.declarative;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.options.DeclarativeOption;
import org.jenkinsci.plugins.workflow.cps.GroovySourceFileAllowlist;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractDockerAgent<D extends AbstractDockerAgent<D>>
extends DeclarativeAgent<D> {
    protected String label;
    protected String args = "";
    protected String registryUrl;
    protected String registryCredentialsId;
    protected String customWorkspace;
    protected boolean reuseNode;
    protected boolean containerPerStageRoot;

    @Nullable
    public String getRegistryUrl() {
        return this.registryUrl;
    }

    @DataBoundSetter
    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    @Nullable
    public String getRegistryCredentialsId() {
        return this.registryCredentialsId;
    }

    @DataBoundSetter
    public void setRegistryCredentialsId(String registryCredentialsId) {
        this.registryCredentialsId = registryCredentialsId;
    }

    public boolean getReuseNode() {
        return this.reuseNode;
    }

    @DataBoundSetter
    public void setReuseNode(boolean reuseNode) {
        this.reuseNode = reuseNode;
    }

    @CheckForNull
    public String getLabel() {
        return this.label;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = label;
    }

    @CheckForNull
    public String getCustomWorkspace() {
        return this.customWorkspace;
    }

    @DataBoundSetter
    public void setCustomWorkspace(String customWorkspace) {
        this.customWorkspace = customWorkspace;
    }

    @CheckForNull
    public String getArgs() {
        return this.args;
    }

    @DataBoundSetter
    public void setArgs(String args) {
        this.args = args;
    }

    public boolean isContainerPerStageRoot() {
        return this.containerPerStageRoot;
    }

    @DataBoundSetter
    public void setContainerPerStageRoot(boolean containerPerStageRoot) {
        this.containerPerStageRoot = containerPerStageRoot;
    }

    public void initialize(Map<String, DeclarativeOption> options, boolean explicitAgentInStage) {
        if (options.get("newContainerPerStage") != null) {
            if (!this.inStage) {
                this.containerPerStageRoot = true;
            } else if (!explicitAgentInStage) {
                this.reuseNode = true;
            }
        }
    }

    public boolean reuseRootAgent(Map<String, DeclarativeOption> options) {
        return options.get("newContainerPerStage") != null;
    }

    @Extension
    public static class ChangelogConditionalScriptAllowlist
    extends GroovySourceFileAllowlist {
        private final String scriptUrl = AbstractDockerAgent.class.getResource("AbstractDockerPipelineScript.groovy").toString();

        public boolean isAllowed(String groovyResourceUrl) {
            return groovyResourceUrl.equals(this.scriptUrl);
        }
    }
}

