/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Node;
import hudson.model.Run;
import java.util.Map;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerFingerprints;
import org.jenkinsci.plugins.docker.workflow.DockerUtils;
import org.jenkinsci.plugins.docker.workflow.Dockerfile;
import org.jenkinsci.plugins.docker.workflow.ImageAction;
import org.jenkinsci.plugins.docker.workflow.client.DockerClient;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Deprecated
public class FromFingerprintStep
extends AbstractStepImpl {
    private static final String FIELD_ID = ".Id";
    private final String dockerfile;
    private final String image;
    private String toolName;
    private String commandLine;

    @DataBoundConstructor
    public FromFingerprintStep(String dockerfile, String image) {
        this.dockerfile = dockerfile;
        this.image = image;
    }

    public String getDockerfile() {
        return this.dockerfile;
    }

    public String getImage() {
        return this.image;
    }

    public String getToolName() {
        return this.toolName;
    }

    @DataBoundSetter
    public void setToolName(String toolName) {
        this.toolName = Util.fixEmpty((String)toolName);
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    @DataBoundSetter
    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "dockerFingerprintFrom";
        }

        @NonNull
        public String getDisplayName() {
            return "Record trace of a Docker image used in FROM";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient FromFingerprintStep step;
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Node node;

        protected Void run() throws Exception {
            FilePath dockerfilePath = this.workspace.child(this.step.dockerfile);
            Dockerfile dockerfile = new Dockerfile(dockerfilePath);
            Map<String, String> buildArgs = DockerUtils.parseBuildArgs(dockerfile, this.step.commandLine);
            String fromImage = dockerfile.getFroms().getLast();
            if (dockerfile.getFroms().isEmpty()) {
                throw new AbortException("could not find FROM instruction in " + dockerfilePath);
            }
            if (buildArgs != null) {
                fromImage = Util.replaceMacro((String)fromImage, buildArgs);
            }
            DockerClient client = new DockerClient(this.launcher, this.node, this.step.toolName);
            String descendantImageId = client.inspectRequiredField(this.env, this.step.image, FromFingerprintStep.FIELD_ID);
            if (fromImage.equals("scratch")) {
                DockerFingerprints.addFromFacet(null, (String)descendantImageId, (Run)this.run);
            } else {
                DockerFingerprints.addFromFacet((String)client.inspectRequiredField(this.env, fromImage, FromFingerprintStep.FIELD_ID), (String)descendantImageId, (Run)this.run);
                ImageAction.add(fromImage, this.run);
            }
            return null;
        }
    }
}

