/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import hudson.FilePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public final class Dockerfile {
    private static final String ARG = "ARG";
    private static final String FROM = "FROM ";
    private FilePath dockerfilePath;
    private LinkedList<String> froms;
    private Map<String, String> args;

    @DataBoundConstructor
    public Dockerfile(FilePath dockerfilePath) throws IOException, InterruptedException {
        this.dockerfilePath = dockerfilePath;
        this.froms = new LinkedList();
        this.args = new HashMap<String, String>();
        this.parse();
    }

    public LinkedList<String> getFroms() {
        return this.froms;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    private void parse() throws IOException, InterruptedException {
        try (InputStream is = this.dockerfilePath.read();
             BufferedReader r = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));){
            String line;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.startsWith(ARG)) {
                    String[] keyVal = this.parseDockerfileArg(line.substring(4));
                    this.args.put(keyVal[0], keyVal[1]);
                    continue;
                }
                if (!line.startsWith(FROM)) continue;
                this.froms.add(line.substring(5));
            }
        }
    }

    protected String[] parseDockerfileArg(String argLine) {
        String[] keyValue = argLine.split("=", 2);
        String key = keyValue[0];
        String value = "";
        if (keyValue.length > 1) {
            value = keyValue[1];
        }
        return new String[]{key, value};
    }
}

