/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow.client;

import com.google.common.base.Optional;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.workflow.client.DockerClient;
import org.jenkinsci.plugins.docker.workflow.client.LaunchResult;

public class WindowsDockerClient
extends DockerClient {
    private static final Logger LOGGER = Logger.getLogger(WindowsDockerClient.class.getName());
    private final Launcher launcher;
    private final Node node;

    public WindowsDockerClient(@Nonnull Launcher launcher, @CheckForNull Node node, @CheckForNull String toolName) {
        super(launcher, node, toolName);
        this.launcher = launcher;
        this.node = node;
    }

    @Override
    public String run(@Nonnull EnvVars launchEnv, @Nonnull String image, @CheckForNull String args, @CheckForNull String workdir, @Nonnull Map<String, String> volumes, @Nonnull Collection<String> volumesFromContainers, @Nonnull EnvVars containerEnv, @Nonnull String user, String ... command) throws IOException, InterruptedException {
        ArgumentListBuilder argb = new ArgumentListBuilder(new String[]{"docker", "run", "-d", "-t"});
        if (args != null) {
            argb.addTokenized(args);
        }
        if (workdir != null) {
            argb.add(new String[]{"-w", workdir});
        }
        for (Map.Entry<String, String> volume : volumes.entrySet()) {
            argb.add(new String[]{"-v", volume.getKey() + ":" + volume.getValue()});
        }
        for (String containerId : volumesFromContainers) {
            argb.add(new String[]{"--volumes-from", containerId});
        }
        for (Map.Entry variable : containerEnv.entrySet()) {
            argb.add("-e");
            argb.addMasked((String)variable.getKey() + "=" + (String)variable.getValue());
        }
        argb.add(image).add(command);
        LaunchResult result = this.launch(launchEnv, false, null, argb);
        if (result.getStatus() == 0) {
            return result.getOut();
        }
        throw new IOException(String.format("Failed to run image '%s'. Error: %s", image, result.getErr()));
    }

    @Override
    public List<String> listProcess(@Nonnull EnvVars launchEnv, @Nonnull String containerId) throws IOException, InterruptedException {
        LaunchResult result = this.launch(launchEnv, false, null, "docker", "top", containerId);
        if (result.getStatus() != 0) {
            throw new IOException(String.format("Failed to run top '%s'. Error: %s", containerId, result.getErr()));
        }
        ArrayList<String> processes = new ArrayList<String>();
        try (StringReader r = new StringReader(result.getOut());
             BufferedReader in = new BufferedReader(r);){
            String line;
            in.readLine();
            while ((line = in.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(line, " ");
                if (stringTokenizer.countTokens() < 1) {
                    throw new IOException("Unexpected `docker top` output : " + line);
                }
                processes.add(stringTokenizer.nextToken());
            }
        }
        return processes;
    }

    @Override
    public Optional<String> getContainerIdIfContainerized() throws IOException, InterruptedException {
        if (this.node == null || this.launch(new EnvVars(), true, null, "sc.exe", "query", "cexecsvc").getStatus() != 0) {
            return Optional.absent();
        }
        LaunchResult getComputerName = this.launch(new EnvVars(), true, null, "hostname");
        if (getComputerName.getStatus() != 0) {
            throw new IOException("Failed to get hostname.");
        }
        String shortID = getComputerName.getOut().toLowerCase();
        LaunchResult getLongIdResult = this.launch(new EnvVars(), true, null, "docker", "inspect", shortID, "--format={{.Id}}");
        if (getLongIdResult.getStatus() != 0) {
            LOGGER.log(Level.INFO, "Running inside of a container but cannot determine container ID from current environment.");
            return Optional.absent();
        }
        return Optional.of((Object)getLongIdResult.getOut());
    }

    @Override
    public String whoAmI() throws IOException, InterruptedException {
        try (ByteArrayOutputStream userId = new ByteArrayOutputStream();){
            this.launcher.launch().cmds(new String[]{"whoami"}).quiet(true).stdout((OutputStream)userId).start().joinWithTimeout((long)CLIENT_TIMEOUT, TimeUnit.SECONDS, this.launcher.getListener());
            String string = userId.toString(Charset.defaultCharset().name()).trim();
            return string;
        }
    }

    private LaunchResult launch(EnvVars env, boolean quiet, FilePath workDir, String ... args) throws IOException, InterruptedException {
        return this.launch(env, quiet, workDir, new ArgumentListBuilder(args));
    }

    private LaunchResult launch(EnvVars env, boolean quiet, FilePath workDir, ArgumentListBuilder argb) throws IOException, InterruptedException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Executing command \"{0}\"", argb);
        }
        Launcher.ProcStarter procStarter = this.launcher.launch();
        if (workDir != null) {
            procStarter.pwd(workDir);
        }
        LaunchResult result = new LaunchResult();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        result.setStatus(procStarter.quiet(quiet).cmds(argb).envs((Map)env).stdout((OutputStream)out).stderr((OutputStream)err).start().joinWithTimeout((long)CLIENT_TIMEOUT, TimeUnit.SECONDS, this.launcher.getListener()));
        String charsetName = Charset.defaultCharset().name();
        result.setOut(out.toString(charsetName));
        result.setErr(err.toString(charsetName));
        return result;
    }
}

