/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow.client;

import com.google.common.base.Optional;
import hudson.FilePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class ControlGroup {
    public final int id;
    public final String subsystems;
    public final String group;

    private ControlGroup(String line) throws NumberFormatException, IndexOutOfBoundsException {
        String[] fields = line.split(":");
        this.id = Integer.parseInt(fields[0]);
        this.subsystems = fields[1];
        this.group = fields[2];
    }

    public static Optional<String> getContainerId(FilePath procfile) throws IOException, InterruptedException {
        return ControlGroup.getContainerId(new InputStreamReader(procfile.read(), StandardCharsets.UTF_8));
    }

    static Optional<String> getContainerId(Reader reader) throws IOException {
        try (BufferedReader r = new BufferedReader(reader);){
            String line;
            while ((line = r.readLine()) != null) {
                ControlGroup cgroup = new ControlGroup(line);
                String containerId = cgroup.getContainerId();
                if (containerId == null) continue;
                Optional optional = Optional.of((Object)containerId);
                return optional;
            }
        }
        return Optional.absent();
    }

    public String getContainerId() throws IOException {
        if (this.group.contains("/docker/")) {
            int i = this.group.lastIndexOf(47);
            if (this.group.length() < i + 1 + 64) {
                throw new IOException("Unexpected cgroup syntax " + this.group);
            }
            return this.group.substring(i + 1, i + 1 + 64);
        }
        if (this.group.startsWith("/ecs/")) {
            int i = this.group.lastIndexOf(47);
            if (this.group.length() < i + 1 + 64) {
                throw new IOException("Unexpected cgroup syntax " + this.group);
            }
            return this.group.substring(i + 1, i + 1 + 64);
        }
        if (this.group.contains("/docker-")) {
            int i = this.group.lastIndexOf("/docker-");
            if (this.group.length() < i + 8 + 64) {
                throw new IOException("Unexpected cgroup syntax " + this.group);
            }
            return this.group.substring(i + 8, i + 8 + 64);
        }
        if (this.group.startsWith("/kubepods/")) {
            int i = this.group.lastIndexOf(47);
            if (this.group.length() < i + 1 + 64) {
                throw new IOException("Unexpected cgroup syntax " + this.group);
            }
            return this.group.substring(i + 1, i + 1 + 64);
        }
        if (this.group.startsWith("/actions_job/")) {
            int i = this.group.lastIndexOf(47);
            if (this.group.length() < i + 1 + 64) {
                throw new IOException("Unexpected cgroup syntax " + this.group);
            }
            return this.group.substring(i + 1, i + 1 + 64);
        }
        return null;
    }
}

