/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.jenkinsci.plugins.docker.commons.tools.DockerTool;
import org.jenkinsci.plugins.docker.workflow.AbstractEndpointStepExecution;
import org.jenkinsci.plugins.docker.workflow.AbstractEndpointStepExecution2;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RegistryEndpointStep
extends Step {
    @Nonnull
    private final DockerRegistryEndpoint registry;
    @CheckForNull
    private String toolName;

    @DataBoundConstructor
    public RegistryEndpointStep(@Nonnull DockerRegistryEndpoint registry) {
        assert (registry != null);
        this.registry = registry;
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.registry;
    }

    public String getToolName() {
        return this.toolName;
    }

    @DataBoundSetter
    public void setToolName(String toolName) {
        this.toolName = Util.fixEmpty((String)toolName);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution2(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withDockerRegistry";
        }

        public String getDisplayName() {
            return "Sets up Docker registry endpoint";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }

        public UninstantiatedDescribable uninstantiate(Step step) throws UnsupportedOperationException {
            RegistryEndpointStep s = (RegistryEndpointStep)step;
            TreeMap<String, String> args = new TreeMap<String, String>();
            args.put("url", s.registry.getUrl());
            args.put("credentialsId", s.registry.getCredentialsId());
            args.put("toolName", s.toolName);
            args.values().removeAll(Collections.singleton(null));
            return new UninstantiatedDescribable(args);
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            if ((arguments = new HashMap<String, Object>(arguments)).containsKey("url") || arguments.containsKey("credentialsId")) {
                if (arguments.containsKey("registry")) {
                    throw new IllegalArgumentException("cannot mix url/credentialsId with registry");
                }
                arguments.put("registry", new DockerRegistryEndpoint((String)arguments.remove("url"), (String)arguments.remove("credentialsId")));
            } else if (!arguments.containsKey("registry")) {
                throw new IllegalArgumentException("must specify url/credentialsId (or registry)");
            }
            return super.newInstance(arguments);
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, EnvVars.class, Node.class, Run.class, FilePath.class, Launcher.class, (Object[])new Class[0]);
        }
    }

    @Deprecated
    public static class Execution
    extends AbstractEndpointStepExecution {
        private static final long serialVersionUID = 1L;
    }

    private static final class Execution2
    extends AbstractEndpointStepExecution2 {
        private static final long serialVersionUID = 1L;
        private transient RegistryEndpointStep step;

        Execution2(RegistryEndpointStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        @Override
        protected KeyMaterialFactory newKeyMaterialFactory() throws IOException, InterruptedException {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            String executable = DockerTool.getExecutable((String)this.step.toolName, (Node)((Node)this.getContext().get(Node.class)), (TaskListener)listener, (EnvVars)envVars);
            return this.step.registry.newKeyMaterialFactory((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), envVars, listener, executable);
        }
    }
}

