/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.impl;

import hudson.EnvVars;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ServerHostKeyMaterialFactory
extends KeyMaterialFactory {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String host;

    public ServerHostKeyMaterialFactory(@Nonnull String host) {
        this.host = host;
    }

    @Override
    public KeyMaterial materialize() throws IOException, InterruptedException {
        EnvVars env = new EnvVars();
        env.put("DOCKER_HOST", this.host);
        return new KeyMaterialImpl(env);
    }

    private static class KeyMaterialImpl
    extends KeyMaterial {
        private static final long serialVersionUID = 1L;

        private KeyMaterialImpl(EnvVars envVars) {
            super(envVars);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

