/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerTool
extends ToolInstallation
implements EnvironmentSpecific<DockerTool>,
NodeSpecific<DockerTool> {
    static final String COMMAND = System.getProperty("DOCKER_COMMAND", "docker");

    @DataBoundConstructor
    public DockerTool(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    @Nonnull
    public static String getExecutable(@CheckForNull String name, @CheckForNull Node node, @Nullable TaskListener listener, @CheckForNull EnvVars env) throws IOException, InterruptedException {
        if (name != null) {
            for (DockerTool tool : ((DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class)).getInstallations()) {
                FilePath homeFP;
                String home;
                if (!tool.getName().equals(name)) continue;
                if (node != null) {
                    tool = tool.forNode(node, listener);
                }
                if (env != null) {
                    tool = tool.forEnvironment(env);
                }
                if ((home = Util.fixEmpty((String)tool.getHome())) == null) continue;
                if (node != null && (homeFP = node.createPath(home)) != null) {
                    return homeFP.child("bin/docker").getRemote();
                }
                return home + "/bin/docker";
            }
        }
        return COMMAND;
    }

    public DockerTool forEnvironment(EnvVars environment) {
        return new DockerTool(this.getName(), environment.expand(this.getHome()), (List<? extends ToolProperty<?>>)this.getProperties());
    }

    public DockerTool forNode(@NonNull Node node, TaskListener log) throws IOException, InterruptedException {
        return new DockerTool(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public void buildEnvVars(EnvVars env) {
        String home = Util.fixEmpty((String)this.getHome());
        if (home != null) {
            env.put("PATH+DOCKER", home + "/bin");
        }
    }

    @Extension
    @Symbol(value={"dockerTool"})
    public static class DescriptorImpl
    extends ToolDescriptor<DockerTool> {
        @NonNull
        public String getDisplayName() {
            return "Docker";
        }

        public DockerTool[] getInstallations() {
            this.load();
            return (DockerTool[])super.getInstallations();
        }

        public void setInstallations(DockerTool ... installations) {
            super.setInstallations((ToolInstallation[])installations);
            this.save();
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return super.getDefaultInstallers();
        }
    }
}

