/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.util.Secret;
import java.io.IOException;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ServerKeyMaterialFactory
extends KeyMaterialFactory {
    @CheckForNull
    private final String key;
    @CheckForNull
    private final String cert;
    @CheckForNull
    private final String ca;
    private static final long serialVersionUID = 1L;

    public ServerKeyMaterialFactory(@CheckForNull DockerServerCredentials credentials) {
        if (credentials != null) {
            this.key = Secret.toString((Secret)credentials.getClientKeySecret());
            this.cert = credentials.getClientCertificate();
            this.ca = credentials.getServerCaCertificate();
        } else {
            this.key = null;
            this.cert = null;
            this.ca = null;
        }
    }

    public ServerKeyMaterialFactory(@CheckForNull String key, @CheckForNull String cert, @CheckForNull String ca) {
        this.key = key;
        this.cert = cert;
        this.ca = ca;
    }

    @Override
    public KeyMaterial materialize() throws IOException, InterruptedException {
        EnvVars e = new EnvVars();
        if (this.key != null && this.cert != null && this.ca != null) {
            FilePath tempCredsDir = this.createSecretsDirectory();
            this.copyInto(tempCredsDir, "key.pem", this.key);
            this.copyInto(tempCredsDir, "cert.pem", this.cert);
            this.copyInto(tempCredsDir, "ca.pem", this.ca);
            e.put("DOCKER_TLS_VERIFY", "1");
            e.put("DOCKER_CERT_PATH", tempCredsDir.getRemote());
            return new ServerKeyMaterial(e, tempCredsDir);
        }
        return new ServerKeyMaterial(e, new FilePath[0]);
    }

    private void copyInto(FilePath dir, String fileName, String content) throws IOException, InterruptedException {
        if (content == null) {
            return;
        }
        dir.child(fileName).write(content, "UTF-8");
    }

    private static final class ServerKeyMaterial
    extends KeyMaterial {
        private final FilePath[] tempDirs;

        protected ServerKeyMaterial(EnvVars envVars, FilePath ... temporaryDirectories) {
            super(envVars);
            this.tempDirs = temporaryDirectories;
        }

        @Override
        public void close() throws IOException {
            Throwable first = null;
            if (this.tempDirs != null) {
                for (FilePath tempDir : this.tempDirs) {
                    try {
                        tempDir.deleteRecursive();
                    }
                    catch (Throwable e) {
                        first = first == null ? e : first;
                    }
                }
            }
            if (first != null) {
                if (first instanceof IOException) {
                    throw (IOException)first;
                }
                if (first instanceof InterruptedException) {
                    throw new IOException(first);
                }
                if (first instanceof RuntimeException) {
                    throw (RuntimeException)first;
                }
                throw new IOException("Error closing credentials.", first);
            }
        }
    }
}

