/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public class ImageNameValidator {
    private static boolean SKIP = Boolean.getBoolean(ImageNameValidator.class.getName() + ".SKIP");
    public static final Pattern VALID_DIGEST = Pattern.compile("^@[a-z0-9]+([+._-][a-z0-9]+)*:[a-zA-Z0-9=_-]+$");
    public static final Pattern VALID_DIGEST_SHA256 = Pattern.compile("^@sha256:[a-z0-9]{64}$");
    public static final Pattern VALID_DIGEST_SHA512 = Pattern.compile("^@sha512:[a-z0-9]{128}$");
    public static final Pattern VALID_TAG = Pattern.compile("^:[a-zA-Z0-9_]([a-zA-Z0-9_.-]){0,127}");
    public static final Pattern VALID_NAME_COMPONENT = Pattern.compile("^[a-zA-Z0-9]+((\\.|_|__|-+)[a-zA-Z0-9]+)*$");

    public static boolean skipped() {
        return SKIP;
    }

    @NonNull
    public static String[] splitUserAndRepo(@NonNull String userAndRepo) {
        String[] args = new String[4];
        if (StringUtils.isEmpty((String)userAndRepo)) {
            return args;
        }
        int slashIdx = userAndRepo.lastIndexOf(47);
        int tagIdx = userAndRepo.lastIndexOf(58);
        int digestIdx = userAndRepo.lastIndexOf(64);
        if (tagIdx == -1 && slashIdx == -1 && digestIdx == -1) {
            args[1] = userAndRepo;
        } else if (tagIdx < slashIdx) {
            args[0] = userAndRepo.substring(0, slashIdx);
            args[1] = userAndRepo.substring(slashIdx + 1);
        } else {
            if (slashIdx != -1) {
                args[0] = userAndRepo.substring(0, slashIdx);
                args[1] = userAndRepo.substring(slashIdx + 1);
            }
            if (digestIdx > 0) {
                String name;
                int start = slashIdx > 0 ? slashIdx + 1 : 0;
                args[1] = name = userAndRepo.substring(start, digestIdx);
                tagIdx = name.lastIndexOf(58);
                if (tagIdx > 0) {
                    args[1] = name.substring(0, tagIdx);
                    args[2] = name.substring(tagIdx);
                }
                args[3] = userAndRepo.substring(digestIdx);
            } else if (tagIdx > 0) {
                int start = slashIdx > 0 ? slashIdx + 1 : 0;
                args[1] = userAndRepo.substring(start, tagIdx);
                args[2] = userAndRepo.substring(tagIdx);
            }
        }
        return args;
    }

    @NonNull
    public static FormValidation validateUserAndRepo(@NonNull String userAndRepo) {
        if (SKIP) {
            return FormValidation.ok();
        }
        String[] args = ImageNameValidator.splitUserAndRepo(userAndRepo);
        if (StringUtils.isBlank((String)args[0]) && StringUtils.isBlank((String)args[1]) && StringUtils.isBlank((String)args[2]) && StringUtils.isBlank((String)args[3])) {
            return FormValidation.error((String)"Bad imageName format: %s", (Object[])new Object[]{userAndRepo});
        }
        FormValidation name = ImageNameValidator.validateName(args[1]);
        FormValidation tag = ImageNameValidator.validateTag(args[2]);
        FormValidation digest = ImageNameValidator.validateDigest(args[3]);
        if (name.kind == FormValidation.Kind.OK && tag.kind == FormValidation.Kind.OK && digest.kind == FormValidation.Kind.OK) {
            return FormValidation.ok();
        }
        if (name.kind != FormValidation.Kind.OK) {
            return name;
        }
        if (tag.kind != FormValidation.Kind.OK) {
            return tag;
        }
        if (digest.kind != FormValidation.Kind.OK) {
            return digest;
        }
        return FormValidation.aggregate(Arrays.asList(name, tag, digest));
    }

    public static void checkUserAndRepo(@NonNull String userAndRepo) throws FormValidation {
        FormValidation validation = ImageNameValidator.validateUserAndRepo(userAndRepo);
        if (validation.kind != FormValidation.Kind.OK) {
            throw validation;
        }
    }

    @NonNull
    public static FormValidation validateDigest(@CheckForNull String digest) {
        if (SKIP) {
            return FormValidation.ok();
        }
        if (StringUtils.isEmpty((String)digest)) {
            return FormValidation.ok();
        }
        if (digest.startsWith("@sha256")) {
            if (digest.length() != 72) {
                return FormValidation.error((String)"Digest length != 72");
            }
            if (!VALID_DIGEST_SHA256.matcher(digest).matches()) {
                return FormValidation.error((String)"Digest must follow the pattern '%s' for sha-256 algorithm", (Object[])new Object[]{VALID_DIGEST_SHA256.pattern()});
            }
            return FormValidation.ok();
        }
        if (digest.startsWith("@sha512")) {
            if (digest.length() != 136) {
                return FormValidation.error((String)"Digest length != 136");
            }
            if (!VALID_DIGEST_SHA512.matcher(digest).matches()) {
                return FormValidation.error((String)"Digest must follow the pattern '%s' for sha-512 algorithm", (Object[])new Object[]{VALID_DIGEST_SHA512.pattern()});
            }
            return FormValidation.ok();
        }
        if (VALID_DIGEST.matcher(digest).matches()) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Digest must follow the pattern '%s'", (Object[])new Object[]{VALID_DIGEST.pattern()});
    }

    @NonNull
    public static FormValidation validateTag(@CheckForNull String tag) {
        if (SKIP) {
            return FormValidation.ok();
        }
        if (StringUtils.isEmpty((String)tag)) {
            return FormValidation.ok();
        }
        if (tag.length() > 128) {
            return FormValidation.error((String)"Tag length > 128");
        }
        if (VALID_TAG.matcher(tag).matches()) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Tag must follow the pattern '%s'", (Object[])new Object[]{VALID_TAG.pattern()});
    }

    public static void checkTag(@CheckForNull String tag) throws FormValidation {
        FormValidation validation = ImageNameValidator.validateTag(tag);
        if (validation.kind != FormValidation.Kind.OK) {
            throw validation;
        }
    }

    @NonNull
    public static FormValidation validateName(@CheckForNull String name) {
        if (SKIP) {
            return FormValidation.ok();
        }
        if (StringUtils.isEmpty((String)name)) {
            return FormValidation.error((String)"Missing name.");
        }
        if (VALID_NAME_COMPONENT.matcher(name).matches()) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Name must follow the pattern '%s'", (Object[])new Object[]{VALID_NAME_COMPONENT.pattern()});
    }

    public static void checkName(String name) throws FormValidation {
        FormValidation validation = ImageNameValidator.validateName(name);
        if (validation.kind != FormValidation.Kind.OK) {
            throw validation;
        }
    }
}

