/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.impl;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class RegistryKeyMaterialFactory
extends KeyMaterialFactory {
    private static final String DOCKER_CONFIG_FILENAME = "config.json";
    private static final String[] BLACKLISTED_PROPERTIES = new String[]{"auths", "credsStore"};
    @Nonnull
    private final String username;
    @Nonnull
    private final String password;
    @Nonnull
    private final URL endpoint;
    @Nonnull
    private final Launcher launcher;
    @Nonnull
    private final EnvVars env;
    @Nonnull
    private final TaskListener listener;
    @Nonnull
    private final String dockerExecutable;

    public RegistryKeyMaterialFactory(@Nonnull String username, @Nonnull String password, @Nonnull URL endpoint, @Nonnull Launcher launcher, @Nonnull EnvVars env, @Nonnull TaskListener listener, @Nonnull String dockerExecutable) {
        this.username = username;
        this.password = password;
        this.endpoint = endpoint;
        this.launcher = launcher;
        this.env = env;
        this.listener = listener;
        this.dockerExecutable = dockerExecutable;
    }

    @Override
    public KeyMaterial materialize() throws IOException, InterruptedException {
        String configJson;
        FilePath dockerConfig = this.createSecretsDirectory();
        FilePath configJsonPath = FilePath.getHomeDirectory((VirtualChannel)this.launcher.getChannel()).child(".docker").child(DOCKER_CONFIG_FILENAME);
        if (configJsonPath.exists() && StringUtils.isNotBlank((String)(configJson = configJsonPath.readToString()))) {
            this.launcher.getListener().getLogger().print("Using the existing docker config file.");
            JSONObject json = JSONObject.fromObject((Object)configJson);
            for (String property : BLACKLISTED_PROPERTIES) {
                Object value = json.remove(property);
                if (value == null) continue;
                this.launcher.getListener().getLogger().print("Removing blacklisted property: " + property);
            }
            dockerConfig.child(DOCKER_CONFIG_FILENAME).write(json.toString(), StandardCharsets.UTF_8.name());
        }
        try {
            EnvVars envWithConfig = new EnvVars(this.env);
            envWithConfig.put("DOCKER_CONFIG", dockerConfig.getRemote());
            if (this.launcher.launch().cmds(new ArgumentListBuilder(new String[]{this.dockerExecutable, "login", "-u", this.username, "-p"}).add(this.password, true).add((Object)this.endpoint)).envs((Map)envWithConfig).stdout(this.listener).join() != 0) {
                throw new AbortException("docker login failed");
            }
        }
        catch (IOException | InterruptedException x) {
            try {
                dockerConfig.deleteRecursive();
            }
            catch (Exception x2) {
                x.addSuppressed(x2);
            }
            throw x;
        }
        return new RegistryKeyMaterial(dockerConfig, new EnvVars(new String[]{"DOCKER_CONFIG", dockerConfig.getRemote()}));
    }

    private static class RegistryKeyMaterial
    extends KeyMaterial {
        private final FilePath dockerConfig;

        RegistryKeyMaterial(FilePath dockerConfig, EnvVars envVars) {
            super(envVars);
            this.dockerConfig = dockerConfig;
        }

        @Override
        public void close() throws IOException {
            try {
                this.dockerConfig.deleteRecursive();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }
    }
}

