/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import hudson.Extension;
import hudson.FilePath;
import hudson.util.Secret;
import java.io.IOException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.impl.AbstractOnDiskBinding;
import org.jenkinsci.plugins.docker.commons.Messages;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerServerCredentialsBinding
extends AbstractOnDiskBinding<DockerServerCredentials> {
    @DataBoundConstructor
    public DockerServerCredentialsBinding(String variable, String credentialsId) {
        super(variable, credentialsId);
    }

    protected Class<DockerServerCredentials> type() {
        return DockerServerCredentials.class;
    }

    protected FilePath write(DockerServerCredentials credentials, FilePath dir) throws IOException, InterruptedException {
        FilePath clientKey = dir.child("key.pem");
        clientKey.write(Secret.toString((Secret)credentials.getClientKeySecret()), null);
        clientKey.chmod(384);
        FilePath clientCert = dir.child("cert.pem");
        clientCert.write(credentials.getClientCertificate(), null);
        clientCert.chmod(384);
        FilePath serverCACert = dir.child("ca.pem");
        serverCACert.write(credentials.getServerCaCertificate(), null);
        serverCACert.chmod(384);
        return dir;
    }

    @Extension
    @Symbol(value={"dockerCert"})
    public static class DescriptorImpl
    extends BindingDescriptor<DockerServerCredentials> {
        protected Class<DockerServerCredentials> type() {
            return DockerServerCredentials.class;
        }

        public String getDisplayName() {
            return Messages.DockerServerCredentialsBinding_DisplayName();
        }
    }
}

