/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.tools;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.docker.commons.tools.DockerTool;
import org.jenkinsci.plugins.docker.commons.tools.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerToolInstaller
extends ToolInstaller {
    private final String version;

    @DataBoundConstructor
    public DockerToolInstaller(String label, String version) {
        super(label);
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public FilePath performInstallation(ToolInstallation toolInstallation, @Nonnull Node node, TaskListener listener) throws IOException, InterruptedException {
        long sourceTimestamp;
        VirtualChannel nodeChannel = node.getChannel();
        if (nodeChannel == null) {
            throw new IllegalStateException("Node is offline");
        }
        String os = (String)nodeChannel.call((Callable)new FindArch());
        URL url = DockerToolInstaller.getDockerImageUrl(os, this.version);
        FilePath install = this.preferredLocation(this.tool, node);
        FilePath timestamp = install.child(".timestamp");
        URLConnection con = null;
        try {
            con = ProxyConfiguration.open((URL)url);
            if (timestamp.exists()) {
                con.setIfModifiedSince(timestamp.lastModified());
            }
            con.connect();
            if (con instanceof HttpURLConnection && ((HttpURLConnection)con).getResponseCode() == 304) {
                FilePath filePath = install;
                return filePath;
            }
            sourceTimestamp = con.getLastModified();
        }
        catch (IOException x) {
            if (install.exists()) {
                if (listener != null) {
                    listener.getLogger().println("Skipping installation: " + x);
                }
                FilePath filePath = install;
                return filePath;
            }
            throw x;
        }
        finally {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
        }
        if (install.exists()) {
            if (timestamp.exists() && sourceTimestamp == timestamp.lastModified()) {
                return install;
            }
            install.deleteContents();
        }
        listener.getLogger().println(Messages.DockerToolInstaller_downloading_docker_client_(this.version));
        FilePath bin = install.child("bin");
        FilePath docker = bin.child("docker");
        if (install.isRemote()) {
            bin.mkdirs();
            try {
                docker.copyFrom(url);
            }
            catch (IOException x) {
                listener.error("Failed to download pre-1.11.x URL " + url + " from agent: " + x);
            }
        }
        if (!docker.exists()) {
            URL tgz = new URL(url + ".tgz");
            install.installIfNecessaryFrom(tgz, listener, "Unpacking " + tgz + " to " + install + " on " + node.getDisplayName());
            bin.mkdirs();
            install.child("docker/docker").renameTo(docker);
            if (!docker.exists()) {
                throw new AbortException(tgz + " did not contain a docker/docker entry as expected");
            }
            install.child("docker").deleteRecursive();
        }
        docker.chmod(511);
        timestamp.touch(sourceTimestamp);
        return install;
    }

    static URL getDockerImageUrl(String os, String version) throws MalformedURLException {
        int i = os.indexOf("/");
        if (DockerToolInstaller.parseVersion(version).isNewerThan(DockerToolInstaller.parseVersion("17.05.0-ce"))) {
            return new URL("https://download.docker.com/" + os.substring(0, i) + "/static/edge/" + os.substring(i + 1) + "/docker-" + version);
        }
        return new URL("https://get.docker.com/builds/" + FindArch.asGetDockerArchName(os) + os.substring(i + 1) + "/docker-" + version);
    }

    private static VersionNumber parseVersion(String version) {
        if (version.equals("latest")) {
            return new VersionNumber("0");
        }
        Matcher matcher = Pattern.compile("(\\d+\\.\\d+\\.\\d+).*").matcher(version);
        if (matcher.matches()) {
            return new VersionNumber(matcher.group(1));
        }
        throw new IllegalArgumentException("Failed to parse version " + version);
    }

    private static class FindArch
    extends MasterToSlaveCallable<String, IOException> {
        private FindArch() {
        }

        private static String asGetDockerArchName(String os) {
            if (os.startsWith("linux")) {
                return "Linux/";
            }
            if (os.startsWith("win")) {
                return "Windows/";
            }
            if (os.startsWith("mac")) {
                return "Darwin/";
            }
            throw new IllegalArgumentException("Failed to recognize OS architecture " + os);
        }

        public String call() throws IOException {
            String arch;
            String os = System.getProperty("os.name").toLowerCase();
            String string = arch = System.getProperty("os.arch").contains("64") ? "x86_64" : "i386";
            if (os.contains("linux")) {
                return "linux/" + arch;
            }
            if (os.contains("windows")) {
                return "win/" + arch;
            }
            if (os.contains("mac")) {
                return "mac/" + arch;
            }
            throw new IOException("Failed to determine OS architecture " + os + ":" + arch);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<DockerToolInstaller> {
        public String getDisplayName() {
            return "Download from docker.com";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == DockerTool.class;
        }
    }
}

