/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.fingerprint;

import hudson.model.Fingerprint;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.util.Hashtable;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerFingerprintFacet;

public abstract class DockerRunPtrFingerprintFacet
extends DockerFingerprintFacet {
    private final String imageId;
    private final Hashtable<String, Fingerprint.RangeSet> usages = new Hashtable();

    DockerRunPtrFingerprintFacet(Fingerprint fingerprint, long timestamp, String imageId) {
        super(fingerprint, timestamp);
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void addFor(Run<?, ?> b) throws IOException {
        this.add(b.getParent().getFullName(), b.getNumber());
    }

    public synchronized void add(String jobFullName, int n) throws IOException {
        this.addWithoutSaving(jobFullName, n);
        this.getFingerprint().save();
    }

    private synchronized void addWithoutSaving(String jobFullName, int n) {
        Fingerprint.RangeSet r = this.usages.get(jobFullName);
        if (r == null) {
            r = new Fingerprint.RangeSet();
            this.usages.put(jobFullName, r);
        }
        r.add(n);
    }

    public Hashtable<String, Fingerprint.RangeSet> getUsages() {
        return new Hashtable<String, Fingerprint.RangeSet>(this.usages);
    }

    public Fingerprint.RangeSet getRangeSet(String jobFullName) {
        Fingerprint.RangeSet r = this.usages.get(jobFullName);
        if (r == null) {
            r = new Fingerprint.RangeSet();
        }
        return r;
    }

    public Fingerprint.RangeSet getRangeSet(Job<?, ?> job) {
        return this.getRangeSet(job.getFullName());
    }
}

